<?php

namespace App\Http\Controllers;

use App\Http\Requests\AlfabetizadoresturmasRequest;
use App\Models\alfabetizadoresturmas;
use App\Models\Escola;
use App\Models\Municipio;
use App\Models\Parceiro;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\isInt;

class AlfabetizadoresturmasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    

    public function index()
    {
        
       // dd(Alfabetizadoresturmas::all());
        $user =  auth()->user();
        $Alfabetizadoresturmas = DB::table('Alfabetizadoresturmas')
        ->join('municipios','municipios.id','=','Alfabetizadoresturmas.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->join('parceiros','parceiros.id','=','Alfabetizadoresturmas.parceiro_id')
        ->join('subniveis','subniveis.id','=','Alfabetizadoresturmas.subnivei_id')
        ->join('niveis','niveis.id','=','subniveis.nivei_id')
        ->join('escolas','escolas.id','=','Alfabetizadoresturmas.escola_id')
        ->join('bancos','bancos.id','=','Alfabetizadoresturmas.banco_id')
        ->join('users','users.id','=','Alfabetizadoresturmas.user_id')
        ->join('turnos','turnos.id','=','Alfabetizadoresturmas.turno_id')
        ->join('referencias','referencias.id','=','Alfabetizadoresturmas.referencia_id')
        ->join('anos','anos.id','=','Alfabetizadoresturmas.ano_id')
        ->leftJoin('aproveitamentos','aproveitamentos.alfabetizadoresturma_id','=','Alfabetizadoresturmas.id')
        ->select('aproveitamentos.id as idAproveitamento','anos.anolectivo','provinces.nome as nome_provincia',
        'municipios.nome as nome_municipio','parceiros.nome as nome_parceiro',
        'nivel','subnivel', 'escolas.nome as nome_escola','escolas.numerodaescola', 'turnos.turno','Alfabetizadoresturmas.*',
        'bancos.nome as banco','bancos.abreviacao','bancos.swift', 'name as user_name_creator', 'users.email as user_email_creator','referencias.referencia')
        ->orderBy("Alfabetizadoresturmas.ano_id","desc")
        ->orderBy("nome_provincia")
        ->orderBy("nome_municipio")
        ->orderBy("nome_do_responsavel")
        ->orderBy("bilhete")
        ->orderBy("nivel")
        ->orderBy("subnivel")

        ->paginate(30);
        //dd($Alfabetizadoresturmas);
        return view('turma.index',compact('Alfabetizadoresturmas','user'));
    }


    public function turmasByParceiros()
    {
        $parceiro_id=1;
        if(!isInt($parceiro_id)){
            abort(403, 'Não autorizado.');
            exit();
        }
        $user =  auth()->user();
        $Alfabetizadoresturmas = DB::table('Alfabetizadoresturmas')
        ->join('municipios','municipios.id','=','Alfabetizadoresturmas.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->join('parceiros','parceiros.id','=','Alfabetizadoresturmas.parceiro_id')
        ->join('subniveis','subniveis.id','=','Alfabetizadoresturmas.subnivei_id')
        ->join('niveis','niveis.id','=','subniveis.nivei_id')
        ->join('escolas','escolas.id','=','Alfabetizadoresturmas.escola_id')
        ->join('bancos','bancos.id','=','Alfabetizadoresturmas.banco_id')
        ->join('users','users.id','=','Alfabetizadoresturmas.user_id')
        ->join('turnos','turnos.id','=','Alfabetizadoresturmas.turno_id')
        ->join('anos','anos.id','=','Alfabetizadoresturmas.ano_id')
        ->leftJoin('anos','anos.id','=','Alfabetizadoresturmas.ano_id')
        ->join('referencias','referencias.id','=','Alfabetizadoresturmas.referencia_id')
        ->select('Alfabetizadoresturmas.*','anos.ano as ano_lectivo','provinces.nome as nome_province',
        'municipios.nome as nome_municipio','parceiros.nome as nome_parceiro',
        'nivel','subnivel', 'escolas.nome as nome_escola','escolas.numerodaescola', 'turnos.turno',
        'bancos.nome as banco','bancos.abreviacao','bancos.swift', 'name as user_name_creator', 'users.email as user_email_creator','referencias.referencia')
        ->where("Alfabetizadoresturmas.parceiro_id",$parceiro_id)
        ->orderBy("nome_province")
        ->orderBy("nome_municipio")
        ->orderBy("nome_do_responsavel")
        ->orderBy("bilhete")
        ->orderBy("nivel")
        ->orderBy("subnivel")
        ->orderBy("anos_como_alfabetizador","desc")
        ->paginate(30);
        dd($Alfabetizadoresturmas);
       // return view('provincia.index',compact('provinces','user'));
    }


    public function turmasByEscolas()
    {
        $escola_id=1;
        if(!isInt($escola_id)){
            abort(403, 'Não autorizado.');
            exit();
        }
        $user =  auth()->user();
        
        
        $Alfabetizadoresturmas = DB::table('Alfabetizadoresturmas')
        ->join('municipios','municipios.id','=','Alfabetizadoresturmas.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->join('parceiros','parceiros.id','=','Alfabetizadoresturmas.parceiro_id')
        ->join('subniveis','subniveis.id','=','Alfabetizadoresturmas.subnivei_id')
        ->join('niveis','niveis.id','=','subniveis.nivei_id')
        ->join('escolas','escolas.id','=','Alfabetizadoresturmas.escola_id')
        ->join('bancos','bancos.id','=','Alfabetizadoresturmas.banco_id')
        ->join('users','users.id','=','Alfabetizadoresturmas.user_id')
        ->join('turnos','turnos.id','=','Alfabetizadoresturmas.turno_id')
        ->join('referencias','referencias.id','=','Alfabetizadoresturmas.referencia_id')
        ->select('provinces.nome as nome_province',
        'municipios.nome as nome_municipio','parceiros.nome as nome_parceiro',
        'nivel','subnivel', 'escolas.nome as nome_escola','escolas.numerodaescola', 'turnos.turno', 'Alfabetizadoresturmas.*',
        'bancos.nome as banco','bancos.abreviacao','bancos.swift', 'name as user_name_creator', 'users.email as user_email_creator','referencias.referencia')
        ->where("Alfabetizadoresturmas.escola_id",$escola_id)
        ->orderBy("nome_province")
        ->orderBy("nome_municipio")
        ->orderBy("nome_do_responsavel")
        ->orderBy("bilhete")
        ->orderBy("nivel")
        ->orderBy("subnivel")
        ->orderBy("anos_como_alfabetizador","desc")
        ->paginate(30);
        dd($Alfabetizadoresturmas);
       // return view('turma.index',compact('provinces','user'));
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $user =  auth()->user();
        $entidadeid = $user->entidade_id;
        
        $municipios = DB::table('municipios')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->select('municipios.*','municipios.nome as nome_municipio','provinces.nome as nome_province')
        ->where("municipios.entidade_id",$entidadeid)
        ->orderBy("provinces.nome")
        ->orderBy("municipios.nome")
        ->get();

        $parceiros = DB::table('parceiros')
        ->join('municipios','municipios.id','=','parceiros.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->select('parceiros.*','municipios.nome as nome_municipio','provinces.nome as nome_province')
        ->where("municipios.entidade_id",$entidadeid)
        ->get();
        
        $users = User::where("entidade_id",$entidadeid)->get();
        $escolas = DB::table('escolas')
        ->join('municipios','municipios.id','=','escolas.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->select('escolas.*','municipios.nome as nome_municipio','provinces.nome as nome_province')
        ->where("municipios.entidade_id",$entidadeid)
        ->get();

        $bancos = DB::table('bancos')->select('*')->orderBy("nome")->get();
        
        $subniveis = DB::table('subniveis')
        ->join('niveis','niveis.id','=','subniveis.nivei_id')
        ->select('niveis.nivel', 'subniveis.*')
        ->orderBy("nivel")
        ->orderBy("subnivel")
        ->get();
        
        $turnos = DB::table('turnos')->select('*')->orderBy("id")->get();

        $projecto_referencias = DB::table('referencias')->select('*')
        ->where("entidade_id",$entidadeid)->orderBy("referencia")->get();

        $anolectivos = DB::table('anos')->select('*')
        ->where("entidade_id",$entidadeid)->orderBy("anolectivo")->get();

        
        return view('turma.create', compact('anolectivos','municipios','parceiros', 'users', 'escolas', 'bancos', 'subniveis','turnos','projecto_referencias'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(AlfabetizadoresturmasRequest $request)
    {
        $user =  auth()->user();
        $entidadeid = $user->entidade_id;
        $dados = $request->all();
        $usuarioid = $user->id;
        $subnivel = $dados['nivel_de_ensino'];
        $funcionario_publico = strtolower($dados['funcionario_publico']);
        if($funcionario_publico!="não"){
            $funcionario_publico = "sim";
        }else{
          //  $dados['agente']="";
        }
        
        $total_alunos_mf = 0;
        $total_alunos_f = 0;
       // $total_alunos_m = 0;

        $alunos_mf_15_a_19_anos = $dados['alunos_mf_15_a_19_anos'];
        $alunos_f_15_a_19_anos = $dados['alunos_f_15_a_19_anos'];

       // dd($alunos_f_15_a_19_anos);

        if($alunos_mf_15_a_19_anos<$alunos_f_15_a_19_anos){
            if ($subnivel>3) {
                return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 17 à 19 Anos");
            } else {
                return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 15 à 19 Anos");
            }
            
        }
       
        $total_alunos_mf += $alunos_mf_15_a_19_anos;
        $total_alunos_f +=$alunos_f_15_a_19_anos;


        $alunos_mf_20_a_24_anos = $dados['alunos_mf_20_a_24_anos'];
        $alunos_f_20_a_24_anos = $dados['alunos_f_20_a_24_anos'];
        if($alunos_mf_20_a_24_anos<$alunos_f_20_a_24_anos){
            
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 20 à 24 Anos");
        }
        $total_alunos_mf += $alunos_mf_20_a_24_anos;
        $total_alunos_f +=$alunos_f_20_a_24_anos;
        

        $alunos_mf_25_a_29_anos = $dados['alunos_mf_25_a_29_anos'];
        $alunos_f_25_a_29_anos = $dados['alunos_f_25_a_29_anos'];
        if($alunos_mf_25_a_29_anos<$alunos_f_25_a_29_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 25 à 29 Anos");
        }
        $total_alunos_mf += $alunos_mf_25_a_29_anos;
        $total_alunos_f +=$alunos_f_25_a_29_anos;

        $alunos_mf_30_a_34_anos = $dados['alunos_mf_30_a_34_anos'];
        $alunos_f_30_a_34_anos = $dados['alunos_f_30_a_34_anos'];
        if($alunos_mf_30_a_34_anos<$alunos_f_30_a_34_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 30 à 34 Anos");
        }
        $total_alunos_mf += $alunos_mf_30_a_34_anos;
        $total_alunos_f +=$alunos_f_30_a_34_anos;

        $alunos_mf_35_a_39_anos = $dados['alunos_mf_35_a_39_anos'];
        $alunos_f_35_a_39_anos = $dados['alunos_f_35_a_39_anos'];
        if($alunos_mf_35_a_39_anos<$alunos_f_35_a_39_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 35 à 39 Anos");
        }
        $total_alunos_mf += $alunos_mf_35_a_39_anos;
        $total_alunos_f +=$alunos_f_35_a_39_anos;

        $alunos_mf_40_a_44_anos = $dados['alunos_mf_40_a_44_anos'];
        $alunos_f_40_a_44_anos = $dados['alunos_f_40_a_44_anos'];
        if($alunos_mf_40_a_44_anos<$alunos_f_40_a_44_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 40 à 44 Anos");
        }
        $total_alunos_mf += $alunos_mf_40_a_44_anos;
        $total_alunos_f +=$alunos_f_40_a_44_anos;

        $alunos_mf_45_a_49_anos = $dados['alunos_mf_45_a_49_anos'];
        $alunos_f_45_a_49_anos = $dados['alunos_f_45_a_49_anos'];
        if($alunos_mf_45_a_49_anos<$alunos_f_45_a_49_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 45 à 49 Anos");
        }
        $total_alunos_mf += $alunos_mf_45_a_49_anos;
        $total_alunos_f +=$alunos_f_45_a_49_anos;

        $alunos_mf_50_a_54_anos = $dados['alunos_mf_50_a_54_anos'];
        $alunos_f_50_a_54_anos = $dados['alunos_f_50_a_54_anos'];
        if($alunos_mf_50_a_54_anos<$alunos_f_50_a_54_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 50 à 54 Anos");
        }
        $total_alunos_mf += $alunos_mf_50_a_54_anos;
        $total_alunos_f +=$alunos_f_50_a_54_anos;

        $alunos_mf_55_a_59_anos = $dados['alunos_mf_55_a_59_anos'];
        $alunos_f_55_a_59_anos = $dados['alunos_f_55_a_59_anos'];
        if($alunos_mf_55_a_59_anos<$alunos_f_55_a_59_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 55 à 59 Anos");
        }
        $total_alunos_mf += $alunos_mf_55_a_59_anos;
        $total_alunos_f +=$alunos_f_55_a_59_anos;

        $alunos_mf_60_a_64_anos = $dados['alunos_mf_60_a_64_anos'];
        $alunos_f_60_a_64_anos = $dados['alunos_f_60_a_64_anos'];
        if($alunos_mf_60_a_64_anos<$alunos_f_60_a_64_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 60 à 64 Anos");
        }
        $total_alunos_mf += $alunos_mf_60_a_64_anos;
        $total_alunos_f +=$alunos_f_60_a_64_anos;

        $alunos_mf_65_ou_mais_anos = $dados['alunos_mf_65_ou_mais_anos'];
        $alunos_f_65_ou_mais_anos = $dados['alunos_f_65_ou_mais_anos'];
        if($alunos_mf_65_ou_mais_anos<$alunos_f_65_ou_mais_anos){
            return redirect()->route('turma.create')->with("error", "Alunos F superior a MF. Intervalo de 65 ou Mais Anos");
        }
        $total_alunos_mf += $alunos_mf_65_ou_mais_anos;
        $total_alunos_f +=$alunos_f_65_ou_mais_anos;
        
        // 
        $file = $request->file('foto_id_frontal');
            if($file!=null){
                $foto_id_frontal = $file->store('assets/img/turma/bilhete');
            }else{
                $foto_id_frontal = 'assets/img/turma/sem_foto.png';
            }

            $file = $request->file('foto_id_trazeira');
            if($file!=null){
                $foto_id_trazeira = $file->store('assets/img/turma/bilhete');
            }else{
                $foto_id_trazeira = 'assets/img/turma/sem_foto.png';
            }


            $file = $request->file('foto_da_habilitcao');
            if($file!=null){
                $foto_da_habilitcao = $file->store('assets/img/turma/habilitacao');
            }else{
                $foto_da_habilitcao = 'assets/img/turma/sem_foto.png';
            }

            $file = $request->file('comprovativo');
            if($file!=null){
                $comprovativo = $file->store('assets/img/turma/banco');
            }else{
                $comprovativo = 'assets/img/turma/sem_foto.png';
            }

            $file = $request->file('lista');
            if($file!=null){
                $foto_lista = $file->store('assets/img/turma/lista_dos_alunos');
            }else{
                $foto_lista = 'assets/img/turma/sem_foto.png';
            }
        
        // 
        
        $Alfabetizadoresturma = alfabetizadoresturmas::create([ 
         'municipio_id' => $dados['municipio'],
         'parceiro_id' => $dados['parceiro'],
         'user_id' => $usuarioid,
         'escola_id' => $dados['escola'],
         'nome_do_responsavel' => $dados['responsavel'],
         'data_de_nascimento' => $dados['nascimento'],
         'morada' => $dados['morada'],
         'bilhete' => $dados['indentificacao'],
         'foto_do_bilhete_frontal' => $foto_id_frontal,
         'foto_do_bilhete_trazeira' => $foto_id_trazeira,
         'habilitcao' => $dados['habilitcao'],
         'foto_da_habilitcao' => $foto_da_habilitcao,
         'telefone_do_responsavel' => $dados['telefone'],
         'email_do_responsavel' => $dados['email'],
         'anos_como_alfabetizador' => $dados['anos'],
         'ano_da_ultima_formacao' => $dados['ano'],
         'organizador' => $dados['organizador'],
         'funcionario_publico' => $funcionario_publico,
         'numero_de_agente' => "",
         'banco_id' => $dados['banco'],
         'nib' => $dados['nib'],
         'iban' => "AO06".$dados['parceiro'],
         'comprovativo' => $comprovativo,
         'subnivei_id' => $subnivel,
         'turno_id' => $dados['turno'],
         'ano_id' => $dados['anolectivo'],
         'referencia_id' => $dados['referencia'],
         'data_de_inicio' => $dados['arranque_da_turma'],
         'alunos_mf_15_a_19_anos' => $alunos_mf_15_a_19_anos,
         'alunos_f_15_a_19_anos' => $alunos_f_15_a_19_anos,
         'alunos_mf_20_a_24_anos' => $alunos_mf_20_a_24_anos,
         'alunos_f_20_a_24_anos' => $alunos_f_20_a_24_anos,
         'alunos_mf_25_a_29_anos' => $alunos_mf_25_a_29_anos,
         'alunos_f_25_a_29_anos' => $alunos_f_25_a_29_anos,
         'alunos_mf_30_a_34_anos' => $alunos_mf_30_a_34_anos,
         'alunos_f_30_a_34_anos' => $alunos_f_30_a_34_anos,
         'alunos_mf_35_a_39_anos' => $alunos_mf_35_a_39_anos,
         'alunos_f_35_a_39_anos' => $alunos_f_35_a_39_anos,
         'alunos_mf_40_a_44_anos' => $alunos_mf_40_a_44_anos,
         'alunos_f_40_a_44_anos' => $alunos_f_40_a_44_anos,
         'alunos_mf_45_a_49_anos' => $alunos_mf_45_a_49_anos,
         'alunos_f_45_a_49_anos' => $alunos_f_45_a_49_anos,
         'alunos_mf_50_a_54_anos' => $alunos_mf_50_a_54_anos,
         'alunos_f_50_a_54_anos' => $alunos_f_50_a_54_anos,
         'alunos_mf_55_a_59_anos' => $alunos_mf_55_a_59_anos,
         'alunos_f_55_a_59_anos' => $alunos_f_55_a_59_anos,
         'alunos_mf_60_a_64_anos' => $alunos_mf_60_a_64_anos,
         'alunos_f_60_a_64_anos' => $alunos_f_60_a_64_anos,
         'alunos_mf_65_ou_mais_anos' => $alunos_mf_65_ou_mais_anos,
         'alunos_f_65_ou_mais_anos' => $alunos_f_65_ou_mais_anos,
         'total_alunos_mf' => $total_alunos_mf,
         'total_alunos_f' => $total_alunos_f,
         'total_alunos_m' => $total_alunos_mf-$total_alunos_f,
         'foto_da_lista' => $foto_lista,
         ]);
    

         return redirect()->route('turma.create')->with("status", "Turma cadastrada com sucesso!");
    }

    /**
     * Display the specified resource.
     */
    public function show(alfabetizadoresturmas $alfabetizadoresturmas)
    {
        $alfabetizadoresturma_id=1;
        if(!isInt($alfabetizadoresturma_id)){
            abort(403, 'Não autorizado.');
            exit();
        }
        //$user =  auth()->user();
        $Alfabetizadoresturmas = DB::table('Alfabetizadoresturmas')
        ->join('municipios','municipios.id','=','Alfabetizadoresturmas.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->join('parceiros','parceiros.id','=','Alfabetizadoresturmas.parceiro_id')
        ->join('subniveis','subniveis.id','=','Alfabetizadoresturmas.subnivei_id')
        ->join('niveis','niveis.id','=','subniveis.nivei_id')
        ->join('escolas','escolas.id','=','Alfabetizadoresturmas.escola_id')
        ->join('bancos','bancos.id','=','Alfabetizadoresturmas.banco_id')
        ->join('users','users.id','=','Alfabetizadoresturmas.user_id')
        ->join('turnos','turnos.id','=','Alfabetizadoresturmas.turno_id')
        ->join('referencias','referencias.id','=','Alfabetizadoresturmas.referencia_id')
        ->select('provinces.nome as nome_province',
        'municipios.nome as nome_municipio','parceiros.nome as nome_parceiro',
        'nivel','subnivel', 'escolas.nome as nome_escola','escolas.numerodaescola', 'turnos.turno', 'Alfabetizadoresturmas.*',
        'bancos.nome as banco','bancos.abreviacao','bancos.swift', 'name as user_name_creator', 'users.email as user_email_creator','referencias.referencia')
        ->where("Alfabetizadoresturmas.id",$alfabetizadoresturma_id)
        ->orderBy("nome_province")
        ->orderBy("nome_municipio")
        ->orderBy("nome_do_responsavel")
        ->orderBy("bilhete")
        ->orderBy("nivel")
        ->orderBy("subnivel")
        ->orderBy("anos_como_alfabetizador","desc")
        ->paginate(30);
        dd($Alfabetizadoresturmas);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $turma_id)
    {

        if(!isInt($turma_id))
        { 
            $turma_id=0;
           
        }
        $user =  auth()->user();
        $entidadeid = $user->entidade_id;

        $turma = alfabetizadoresturmas::findOrFail($turma_id);
        $municipio = Municipio::where(["id"=>$turma->municipio_id,"entidade_id"=>$entidadeid])->get();
        
        if(count($municipio)==0){
            abort(403, 'Não autorizado.');
            exit();
        }
        
        
        $municipios = DB::table('municipios')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->select('municipios.*','municipios.nome as nome_municipio','provinces.nome as nome_province')
        ->where("municipios.entidade_id",$entidadeid)
        ->orderBy("provinces.nome")
        ->orderBy("municipios.nome")
        ->get();

        $parceiros = DB::table('parceiros')
        ->join('municipios','municipios.id','=','parceiros.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->select('parceiros.*','municipios.nome as nome_municipio','provinces.nome as nome_province')
        ->where("municipios.entidade_id",$entidadeid)
        ->get();
        
        $users = User::where("entidade_id",$entidadeid)->get();
        $escolas = DB::table('escolas')
        ->join('municipios','municipios.id','=','escolas.municipio_id')
        ->join('provinces','provinces.id','=','municipios.province_id')
        ->select('escolas.*','municipios.nome as nome_municipio','provinces.nome as nome_province')
        ->where("municipios.entidade_id",$entidadeid)
        ->get();

        $bancos = DB::table('bancos')->select('*')->orderBy("nome")->get();
        
        $subniveis = DB::table('subniveis')
        ->join('niveis','niveis.id','=','subniveis.nivei_id')
        ->select('niveis.nivel', 'subniveis.*')
        ->orderBy("nivel")
        ->orderBy("subnivel")
        ->get();
        
        $turnos = DB::table('turnos')->select('*')->orderBy("id")->get();

        $projecto_referencias = DB::table('referencias')->select('*')
        ->where("entidade_id",$entidadeid)->orderBy("referencia")->get();

        $anolectivos = DB::table('anos')->select('*')
        ->where("entidade_id",$entidadeid)->orderBy("anolectivo")->get();

        //dd($this->getAproveitamento($turma_id));
        $aproveitamento = $this->getAproveitamento($turma_id);
        return view('turma.edit', compact('aproveitamento','turma','anolectivos','municipios','parceiros', 'users', 'escolas', 'bancos', 'subniveis','turnos','projecto_referencias'));
    }
    public function update(AlfabetizadoresturmasRequest $request){
        $dados = $request->all();
        $metodo = $dados["metodo"];
        return $this->update_dados1($request);
    }
    public function change(Request $request){
            $dados = $request->all();
            $metodo = $dados["metodo"];
            /*
            if($metodo=="dados1"){
                $this->update_dados1($request);
            }  
            else 
            */
            if($metodo=="dados2"){
                $this->update_dados2($request); // Bi
            }
            else if($metodo=="dados3"){
                $this->update_dados3($request); // habilitacao
            }
            else if($metodo=="dados4"){
                $this->update_dados4($request); // comprovativo
            }
            else if($metodo=="dados5"){
                $this->update_dados5($request); // lista
            }   
            else{
                abort(403, 'Não autorizado.');
                exit();
            }
    }   
    /**
     * Update the specified resource in storage.
     */
    public function update_dados1(Request $request)
    {
        $user =  auth()->user();
        $entidadeid = $user->entidade_id;
        $dados = $request->all();
        $turma_id = $dados["turma"];
        if(!isInt($turma_id))
        { 
            $turma_id=0;
           
        }
        
        $turma = alfabetizadoresturmas::findOrFail($turma_id);
        $municipio = Municipio::where(["id"=>$turma->municipio_id,"entidade_id"=>$entidadeid])->get();
        
        if(count($municipio)==0){
            abort(403, 'Não autorizado.');
            exit();
        }


        $usuarioid = $user->id;
        $subnivel = $dados['nivel_de_ensino'];
        $funcionario_publico = strtolower($dados['funcionario_publico']);
        if($funcionario_publico!="não"){
            $funcionario_publico = "sim";
        }else{
          //  $dados['agente']="";
        }
        
        $total_alunos_mf = 0;
        $total_alunos_f = 0;
       // $total_alunos_m = 0;

        $alunos_mf_15_a_19_anos = $dados['alunos_mf_15_a_19_anos'];
        $alunos_f_15_a_19_anos = $dados['alunos_f_15_a_19_anos'];

       // dd($alunos_f_15_a_19_anos);

        if($alunos_mf_15_a_19_anos<$alunos_f_15_a_19_anos){
            if ($subnivel>3) {
                return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 17 à 19 Anos");
            } else {
                return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 15 à 19 Anos");
            }
            
        }
       
        $total_alunos_mf += $alunos_mf_15_a_19_anos;
        $total_alunos_f +=$alunos_f_15_a_19_anos;


        $alunos_mf_20_a_24_anos = $dados['alunos_mf_20_a_24_anos'];
        $alunos_f_20_a_24_anos = $dados['alunos_f_20_a_24_anos'];
        if($alunos_mf_20_a_24_anos<$alunos_f_20_a_24_anos){
            
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 20 à 24 Anos");
        }
        $total_alunos_mf += $alunos_mf_20_a_24_anos;
        $total_alunos_f +=$alunos_f_20_a_24_anos;
        

        $alunos_mf_25_a_29_anos = $dados['alunos_mf_25_a_29_anos'];
        $alunos_f_25_a_29_anos = $dados['alunos_f_25_a_29_anos'];
        if($alunos_mf_25_a_29_anos<$alunos_f_25_a_29_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 25 à 29 Anos");
        }
        $total_alunos_mf += $alunos_mf_25_a_29_anos;
        $total_alunos_f +=$alunos_f_25_a_29_anos;

        $alunos_mf_30_a_34_anos = $dados['alunos_mf_30_a_34_anos'];
        $alunos_f_30_a_34_anos = $dados['alunos_f_30_a_34_anos'];
        if($alunos_mf_30_a_34_anos<$alunos_f_30_a_34_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 30 à 34 Anos");
        }
        $total_alunos_mf += $alunos_mf_30_a_34_anos;
        $total_alunos_f +=$alunos_f_30_a_34_anos;

        $alunos_mf_35_a_39_anos = $dados['alunos_mf_35_a_39_anos'];
        $alunos_f_35_a_39_anos = $dados['alunos_f_35_a_39_anos'];
        if($alunos_mf_35_a_39_anos<$alunos_f_35_a_39_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 35 à 39 Anos");
        }
        $total_alunos_mf += $alunos_mf_35_a_39_anos;
        $total_alunos_f +=$alunos_f_35_a_39_anos;

        $alunos_mf_40_a_44_anos = $dados['alunos_mf_40_a_44_anos'];
        $alunos_f_40_a_44_anos = $dados['alunos_f_40_a_44_anos'];
        if($alunos_mf_40_a_44_anos<$alunos_f_40_a_44_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 40 à 44 Anos");
        }
        $total_alunos_mf += $alunos_mf_40_a_44_anos;
        $total_alunos_f +=$alunos_f_40_a_44_anos;

        $alunos_mf_45_a_49_anos = $dados['alunos_mf_45_a_49_anos'];
        $alunos_f_45_a_49_anos = $dados['alunos_f_45_a_49_anos'];
        if($alunos_mf_45_a_49_anos<$alunos_f_45_a_49_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 45 à 49 Anos");
        }
        $total_alunos_mf += $alunos_mf_45_a_49_anos;
        $total_alunos_f +=$alunos_f_45_a_49_anos;

        $alunos_mf_50_a_54_anos = $dados['alunos_mf_50_a_54_anos'];
        $alunos_f_50_a_54_anos = $dados['alunos_f_50_a_54_anos'];
        if($alunos_mf_50_a_54_anos<$alunos_f_50_a_54_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 50 à 54 Anos");
        }
        $total_alunos_mf += $alunos_mf_50_a_54_anos;
        $total_alunos_f +=$alunos_f_50_a_54_anos;

        $alunos_mf_55_a_59_anos = $dados['alunos_mf_55_a_59_anos'];
        $alunos_f_55_a_59_anos = $dados['alunos_f_55_a_59_anos'];
        if($alunos_mf_55_a_59_anos<$alunos_f_55_a_59_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 55 à 59 Anos");
        }
        $total_alunos_mf += $alunos_mf_55_a_59_anos;
        $total_alunos_f +=$alunos_f_55_a_59_anos;

        $alunos_mf_60_a_64_anos = $dados['alunos_mf_60_a_64_anos'];
        $alunos_f_60_a_64_anos = $dados['alunos_f_60_a_64_anos'];
        if($alunos_mf_60_a_64_anos<$alunos_f_60_a_64_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 60 à 64 Anos");
        }
        $total_alunos_mf += $alunos_mf_60_a_64_anos;
        $total_alunos_f +=$alunos_f_60_a_64_anos;

        $alunos_mf_65_ou_mais_anos = $dados['alunos_mf_65_ou_mais_anos'];
        $alunos_f_65_ou_mais_anos = $dados['alunos_f_65_ou_mais_anos'];
        if($alunos_mf_65_ou_mais_anos<$alunos_f_65_ou_mais_anos){
            return redirect()->back()->with("error", "Alunos F superior a MF. Intervalo de 65 ou Mais Anos");
        }
        $total_alunos_mf += $alunos_mf_65_ou_mais_anos;
        $total_alunos_f +=$alunos_f_65_ou_mais_anos;
        
        
        
        $turma->update([ 
         'municipio_id' => $dados['municipio'],
         'parceiro_id' => $dados['parceiro'],
         'user_id' => $usuarioid,
         'escola_id' => $dados['escola'],
         'nome_do_responsavel' => $dados['responsavel'],
         'data_de_nascimento' => $dados['nascimento'],
         'morada' => $dados['morada'],
         'bilhete' => $dados['indentificacao'],
         //'foto_do_bilhete_frontal' => $foto_id_frontal,
        // 'foto_do_bilhete_trazeira' => $foto_id_trazeira,
         'habilitcao' => $dados['habilitcao'],
        // 'foto_da_habilitcao' => $foto_da_habilitcao,
         'telefone_do_responsavel' => $dados['telefone'],
         'email_do_responsavel' => $dados['email'],
         'anos_como_alfabetizador' => $dados['anos'],
         'ano_da_ultima_formacao' => $dados['ano'],
         'organizador' => $dados['organizador'],
         'funcionario_publico' => $funcionario_publico,
         'numero_de_agente' => "",
         'banco_id' => $dados['banco'],
         'nib' => $dados['nib'],
         'iban' => "AO06".$dados['parceiro'],
        // 'comprovativo' => $comprovativo,
         'subnivei_id' => $subnivel,
         'turno_id' => $dados['turno'],
         'ano_id' => $dados['anolectivo'],
         'referencia_id' => $dados['referencia'],
         'data_de_inicio' => $dados['arranque_da_turma'],
         'alunos_mf_15_a_19_anos' => $alunos_mf_15_a_19_anos,
         'alunos_f_15_a_19_anos' => $alunos_f_15_a_19_anos,
         'alunos_mf_20_a_24_anos' => $alunos_mf_20_a_24_anos,
         'alunos_f_20_a_24_anos' => $alunos_f_20_a_24_anos,
         'alunos_mf_25_a_29_anos' => $alunos_mf_25_a_29_anos,
         'alunos_f_25_a_29_anos' => $alunos_f_25_a_29_anos,
         'alunos_mf_30_a_34_anos' => $alunos_mf_30_a_34_anos,
         'alunos_f_30_a_34_anos' => $alunos_f_30_a_34_anos,
         'alunos_mf_35_a_39_anos' => $alunos_mf_35_a_39_anos,
         'alunos_f_35_a_39_anos' => $alunos_f_35_a_39_anos,
         'alunos_mf_40_a_44_anos' => $alunos_mf_40_a_44_anos,
         'alunos_f_40_a_44_anos' => $alunos_f_40_a_44_anos,
         'alunos_mf_45_a_49_anos' => $alunos_mf_45_a_49_anos,
         'alunos_f_45_a_49_anos' => $alunos_f_45_a_49_anos,
         'alunos_mf_50_a_54_anos' => $alunos_mf_50_a_54_anos,
         'alunos_f_50_a_54_anos' => $alunos_f_50_a_54_anos,
         'alunos_mf_55_a_59_anos' => $alunos_mf_55_a_59_anos,
         'alunos_f_55_a_59_anos' => $alunos_f_55_a_59_anos,
         'alunos_mf_60_a_64_anos' => $alunos_mf_60_a_64_anos,
         'alunos_f_60_a_64_anos' => $alunos_f_60_a_64_anos,
         'alunos_mf_65_ou_mais_anos' => $alunos_mf_65_ou_mais_anos,
         'alunos_f_65_ou_mais_anos' => $alunos_f_65_ou_mais_anos,
         'total_alunos_mf' => $total_alunos_mf,
         'total_alunos_f' => $total_alunos_f,
         'total_alunos_m' => $total_alunos_mf-$total_alunos_f,
        // 'foto_da_lista' => $foto_lista,
         ]);
    

         return redirect()->back()->with("status", "Turma atualizada com sucesso!");
    }

    public function update_dados2(Request $request)
    {
            $user =  auth()->user();
            $entidadeid = $user->entidade_id;
            $dados = $request->all();
            $turma_id = $dados["turma"];
            if(!isInt($turma_id))
            { 
                $turma_id=0;
            
            }
            
            $turma = alfabetizadoresturmas::findOrFail($turma_id);
            $municipio = Municipio::where(["id"=>$turma->municipio_id,"entidade_id"=>$entidadeid])->get();
            
            if(count($municipio)==0){
                abort(403, 'Não autorizado.');
                exit();
            }
        
            $file = $request->file('foto_id_frontal');
            if($file!=null){
                    $foto_id_frontal = $file->store('assets/img/turma/bilhete');
            }else{
                abort(403, 'Não autorizado.');
                exit();
            }

            $file = $request->file('foto_id_trazeira');
            if($file!=null){
                $foto_id_trazeira = $file->store('assets/img/turma/bilhete');
            }else{
                $foto_id_trazeira = 'assets/img/turma/sem_foto.png';
            }


            $turma->update([ 
                'foto_do_bilhete_frontal' => $foto_id_frontal,
                'foto_do_bilhete_trazeira' => $foto_id_trazeira,
            ]);
    

         return redirect()->back()->with("status", "Turma atualizada com sucesso!");
    }
    public function update_dados3(Request $request)
    {
            $user =  auth()->user();
            $entidadeid = $user->entidade_id;
            $dados = $request->all();
            $turma_id = $dados["turma"];
            if(!isInt($turma_id))
            { 
                $turma_id=0;
            
            }
            
            $turma = alfabetizadoresturmas::findOrFail($turma_id);
            $municipio = Municipio::where(["id"=>$turma->municipio_id,"entidade_id"=>$entidadeid])->get();
            
            if(count($municipio)==0){
                abort(403, 'Não autorizado.');
                exit();
            }
        
        

            $file = $request->file('foto_da_habilitcao');
            if($file!=null){
                $foto_da_habilitcao = $file->store('assets/img/turma/habilitacao');
            }else{
                $foto_da_habilitcao = 'assets/img/turma/sem_foto.png';
            }
            
            $turma->update([ 
                'foto_da_habilitcao' => $foto_da_habilitcao,
            ]);
    

            return redirect()->back()->with("status", "Turma atualizada com sucesso!");
    }
    public function update_dados4(Request $request)
    {
            $user =  auth()->user();
            $entidadeid = $user->entidade_id;
            $dados = $request->all();
            $turma_id = $dados["turma"];
            if(!isInt($turma_id))
            { 
                $turma_id=0;
            
            }
            
            $turma = alfabetizadoresturmas::findOrFail($turma_id);
            $municipio = Municipio::where(["id"=>$turma->municipio_id,"entidade_id"=>$entidadeid])->get();
            
            if(count($municipio)==0){
                abort(403, 'Não autorizado.');
                exit();
            }
        
        

            $file = $request->file('comprovativo');
            if($file!=null){
                $comprovativo = $file->store('assets/img/turma/banco');
            }else{
                $comprovativo = 'assets/img/turma/sem_foto.png';
            }

           $turma->update([ 
                'comprovativo' => $comprovativo,
            ]);
    

            return redirect()->back()->with("status", "Turma atualizada com sucesso!");
    }

    public function update_dados5(Request $request)
    {
            $user =  auth()->user();
            $entidadeid = $user->entidade_id;
            $dados = $request->all();
            $turma_id = $dados["turma"];
            if(!isInt($turma_id))
            { 
                $turma_id=0;
            
            }
            
            $turma = alfabetizadoresturmas::findOrFail($turma_id);
            $municipio = Municipio::where(["id"=>$turma->municipio_id,"entidade_id"=>$entidadeid])->get();
            
            if(count($municipio)==0){
                abort(403, 'Não autorizado.');
                exit();
            }
        
            $file = $request->file('lista');
            if($file!=null){
                $foto_lista = $file->store('assets/img/turma/lista_dos_alunos');
            }else{
                $foto_lista = 'assets/img/turma/sem_foto.png';
            }
        
            // 
            
            $turma->update([ 
                    'foto_da_lista' => $foto_lista,
            ]);
            
            return redirect()->back()->with("status", "Turma atualizada com sucesso!");
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        $id = $request->turma;
        
        if(!isInt($id))
        { 
            $id=0;
           
        }
        $user = auth()->user();
        $Registo = alfabetizadoresturmas::findORFail($id);
        if(($user->role_id==1 or $user->role_id==2) or ($user->id==$Registo->user_id)){
            $Registo->delete();
            return redirect()->back()->with("status","Turma eliminada com sucesso!");
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }


    public function getAproveitamento(String $turmaid)
    {
        $aproveitamentos = DB::table('aproveitamentos')
        ->leftJoin('users','users.id','=','aproveitamentos.user_id')
        ->select('aproveitamentos.*','users.name','users.email')
        ->where('alfabetizadoresturma_id',$turmaid)
        ->first();
        return  $aproveitamentos;
    }


}
