<?php

namespace App\Http\Controllers;

use App\Models\nivei;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NiveiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user =  auth()->user(); 
        $niveis = DB::table('niveis')
            // ->join('subniveis', 'niveis.id', '=', 'subniveis.nivei_id')
            ->join('entidades', 'niveis.entidade_id', '=', 'entidades.id')
            ->select('niveis.*','entidades.nome')
            ->where("entidades.id",$user->entidade_id)
            ->paginate(10);

        $subniveis = DB::table('niveis')
            ->join('subniveis', 'niveis.id', '=', 'subniveis.nivei_id')
            ->join('entidades', 'niveis.entidade_id', '=', 'entidades.id')
            ->select('niveis.nivel', 'subniveis.*')
            ->where("entidades.id",$user->entidade_id)
            ->paginate(10);
        //dd($niveis);
        return view('nivel.index', compact('niveis','subniveis','user'));
    }

    /**
     * Activate the user
     */
    public function activate_nivel(Request $request){
        $user = auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $dados = $request->all();
            $niveis = nivei::findORFail($dados['valor']);
            $niveis->update(
                [
                    'status'=>'Activo',
                ]
            );
            return redirect()->back()->with('status','Nível de ensino '.$niveis->nivel.' ativado com sucesso.');
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * DeActivate the user
     */
    public function deactivate_nivel(Request $request){
        
        $user = auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $dados = $request->all();
            $niveis = nivei::findORFail($dados['valor']);
            $niveis->update(
                [
                    'status'=>'Inactivo',
                ]
            );
            return redirect()->back()->with('status','Nível de ensino '.$niveis->nivel.' desativado com sucesso.');
            ;
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }
}
