<?php

namespace App\Http\Controllers;

use App\Http\Requests\RegistoRequest;
use App\Models\Categoria;
use App\Models\Departamento;
use App\Models\Municipio;
use App\Models\Registo;
use App\Models\User;
use App\Models\Visto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\isInt;

class RegistoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $user =  auth()->user();
        //$registos = Registo::paginate();
        $registos = DB::table('registos')
            ->join('users', 'registos.user_id', '=', 'users.id')
            ->join('categorias', 'registos.categoria_id', '=', 'categorias.id')
            ->join('departamentos', 'registos.departamento_id', '=', 'departamentos.id')
            ->join('municipios', 'registos.municipio_id', '=', 'municipios.id')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->leftJoin('vistos', 'registos.id', '=', 'vistos.registo_id')
            ->select('registos.id','registos.user_id','registos.created_at','registos.updated_at','registos.anexo','registos.anexo1', 'registos.descricao','registos.nota', 'registos.departamento_id', 'name', 'categoria','departamento',
            'provinces.nome as nome_provincia', 'municipios.nome as nome_municipio', 
            DB::raw('COUNT(vistos.id) as total_vistos')
            )
        ->where("entidades.id",$user->entidade_id)
        ->groupBy('registos.id','registos.user_id', 'registos.created_at','registos.updated_at','registos.departamento_id','registos.anexo','registos.anexo1', 'registos.descricao','registos.nota','registos.municipio_id','registos.id', 'users.name', 'categorias.categoria', 'departamentos.departamento', 'provinces.nome', 'municipios.nome')
        ->orderBy('registos.id','desc')
      //  ->orderBy('nome_municipio','asc')
        //->orderBy('nome','asc')
        ->paginate(10);
        //dd($registos);
        return view('registo.index',compact('registos','user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $municipios = Municipio::all();
            $categorias = Categoria::all();
            $departamentos = Departamento::all();
            
           return view('registo.create',compact('municipios','categorias','departamentos'));
        }
        else
        {
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(RegistoRequest $request)
    {
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){

            $file = $request->file('anexo');
            if($file!=null){
                $patha_nexo = $file->store('assets/img/registos');
               // $patha_nexo = '';
            }else{
                $patha_nexo = '';
            }

            $file = $request->file('anexo1');
            if($file!=null){
                $patha_nexo1 = $file->store('assets/img/registos');
                //$patha_nexo1 = '';
            }else{
                $patha_nexo1 = '';
            }

            $dados = $request->all();
            $municipio = Municipio::find($dados['municipio']);
            //dd($dados);
            $registo = Registo::create(
                [
                "municipio_id" => $municipio->id, 
                "province_id" => $municipio->province_id, 
                "descricao" => $dados['descricao'], 
                "nota" => $dados['nota'], 
                "categoria_id" => $dados['categoria'], 
                "departamento_id" => $dados['departamento'], 
                "anexo" => $patha_nexo, 
                "anexo1" => $patha_nexo1, 
                "anexo2" => 'SEM ANEXO', 
                "anexo3" =>  'SEM ANEXO', 
                "estado" => "Validado",
                'user_id' =>$user->id, // responsável
                'entidade_id' =>$user->entidade_id
                ]
            );

          // dd($registo);
           return redirect()->route('registo.create')->with("status", "Registo criado com sucesso!");
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $valor)
    {
        $user =  auth()->user();
        if(!isInt($valor)){
            abort(403, 'Não autorizado.');
            exit();
        }
        $registos = DB::table('registos')
            ->join('categorias', 'registos.categoria_id', '=', 'categorias.id')
            ->join('departamentos', 'registos.departamento_id', '=', 'departamentos.id')
            ->join('municipios', 'registos.municipio_id', '=', 'municipios.id')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->join('vistos', 'registos.id', '=', 'vistos.registo_id')
            ->join('users', 'vistos.user_id', '=', 'users.id')
            ->select('registos.*', 'categoria','departamento',
            'provinces.nome as nome_provincia', 'municipios.nome as nome_municipio',
            'vistos.id','vistos.created_at','name','users.email','users.photo')
            ->where(["entidades.id"=>$user->entidade_id,"registos.id"=>$valor])
            ->orderBy('registos.id','desc')
            ->paginate(10);
           // dd($registos);
            return view('registo.show',compact('registos','user'));
    
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $registo_id)
    {
        if(!isInt($registo_id))
        { 
            $registo_id=0;
        }
        $user =  auth()->user();
        $registo = Registo::findOrFail($registo_id);
        if(($user->role_id==1 or $user->role_id==2) or ($user->id==$registo->user_id)){
            // Actulizar
            $municipios = Municipio::all();
            $categorias = Categoria::all();
            $departamentos = Departamento::all();
           // dd()
            return view('registo.edit',compact('registo','municipios','categorias','departamentos')); 
        }
        else
        {
            abort(403, 'Não autorizado.');
            exit();
        }
        
        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Registo $registo)
    {
        //
        /*

            $Registo->update(
                [
                    
                    'nome'=>$dados['nome'],
                    'codigo'=>$dados['codigo'],
                    'latitude'=>$lat,
                    'longitude'=>$long,
                    'precision'=>$precision,
                    'user_id'=>$dados['user']
                ]
            );
        */
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        $id = $request->valor;
        
        if(!isInt($id))
        { 
            $id=0;
           
        }
        $user = auth()->user();
        $Registo = Registo::findORFail($id);
        if($user->entidade_id== $user->entidade_id and ($user->role_id==1 or $user->role_id==2) or ($user->id==$Registo->user_id)){
            $Registo->delete();
            return redirect()->back();
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
        
        
    }

    public function visto(Request $request)
    {
        $id = $request->valor;
        if(!isInt($id))
        { 
            $id=0;
        }
        $user = auth()->user();
        $Registo = Registo::findORFail($id);
        $Vistos = DB::table('vistos')
            ->select('id')
            ->where(["user_id"=>$user->id,"registo_id"=>$id])
            ->limit(2)
            ->get();
        if(count($Vistos)>0){
            return redirect()->back()->with('status','Você já marcou este Registo como visto aos '.$Registo->created_at);
        }
        if($user->entidade_id==$Registo->entidade_id) // Visto
        { 
            $Visto = Visto::create(
                [
                "descricao" =>'Visto', 
                "anexo" => '',
                "anexo1" => '', 
                "user_id" => $user->id, 
                "registo_id" => $id, 
                ]
            );
            return redirect()->back()->with('status','Registo marcado como visto.');
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    

}
