<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AlfabetizadoresturmasRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
                'municipio' => 'required|integer', 
                'parceiro' => 'required|integer', 
                //'usuario' => 'required|integer', 
                'escola' => 'required|integer', 
                'responsavel' => 'required|max:100|min:5', 
                'nascimento' => 'required|date', 
                'morada' => 'nullable|max:255', 
                'indentificacao' => 'required|max:18', 
               // 'foto_id_frontal' => 'required|image|mimes:png,jpg,jpeg|max:1024', //
               // 'foto_id_trazeira' => 'nullable|image|mimes:png,jpg,jpeg|max:1024', // 
                'habilitcao' => 'required|max:100', 
              //  'foto_da_habilitcao' => 'required|image|mimes:png,jpg,jpeg|max:1024', //
                'telefone' => 'nullable|integer', 
                'email' => 'nullable|email', 
                'anos' => 'required|integer|min:0|max:70', // anos_como_alfabetizador
                'ano' => 'nullable|integer|min:1975|max:'.date("Y"),  // ano_da_ultima_formacao
                'organizador' => 'nullable|max:200', 
                'funcionario_publico' => 'required|max:4', 
                'agente' => 'nullable', 
                'banco' => 'required|integer', 
                //'nib' => 'required|integer|min_digits:17|max_digits:17', 
               //'iban', 
                //'comprovativo' => 'nullable|image|mimes:png,jpg,jpeg|max:1024', // 
                'nivel_de_ensino' => 'required|integer',  
                'turno' => 'required|integer',  
                'referencia' => 'required|integer',  
                'arranque_da_turma' => 'required|date', 
                'alunos_mf_15_a_19_anos' => 'required|integer|min:0|max:80', 
                'alunos_f_15_a_19_anos' => 'required|integer|min:0|max:80', 
               'alunos_mf_20_a_24_anos' => 'required|integer|min:0|max:80',
               'alunos_f_20_a_24_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_25_a_29_anos' => 'required|integer|min:0|max:80',
               'alunos_f_25_a_29_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_30_a_34_anos' => 'required|integer|min:0|max:80',
               'alunos_f_30_a_34_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_35_a_39_anos' => 'required|integer|min:0|max:80',
               'alunos_f_35_a_39_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_40_a_44_anos' => 'required|integer|min:0|max:80',
               'alunos_f_40_a_44_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_45_a_49_anos' => 'required|integer|min:0|max:80',
               'alunos_f_45_a_49_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_50_a_54_anos' => 'required|integer|min:0|max:80',
               'alunos_f_50_a_54_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_55_a_59_anos' => 'required|integer|min:0|max:80',
               'alunos_f_55_a_59_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_60_a_64_anos' => 'required|integer|min:0|max:80',
               'alunos_f_60_a_64_anos' => 'required|integer|min:0|max:80',
               'alunos_mf_65_ou_mais_anos' => 'required|integer|min:0|max:80',
               'alunos_f_65_ou_mais_anos' => 'required|integer|min:0|max:80',
               'anolectivo' => 'required|integer|min:0',
               //'total_alunos_f' => 'required|integer|min:0|max:80',
               //'total_alunos_m' => 'required|integer|min:0|max:80',
              // 'foto_da_lista' => 'nullable|image|mimes:png,jpg,jpeg|max:1024' // 
            ];
        ;
    }
}
