<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Registo extends Model
{
    use HasFactory;
    
    protected $fillable=["municipio_id", "province_id", "descricao", "nota", 
    "categoria_id", "departamento_id", "anexo", "anexo1", "anexo2", "anexo3", 
    "entidade_id", "user_id", "estado"];

    //protected $withCount = ['visto'];
    
    //tem muitos vistos
    public function vistos():HasMany
    {
        return $this->hasMany(Visto::class);
    }
    
    //Pertence um registo
    public function user():BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    //Pertence um registo
    public function municipio():BelongsTo
    {
        return $this->belongsTo(Municipio::class);
    }

    //Pertence um registo
    public function province():BelongsTo
    {
        return $this->belongsTo(Province::class);
    }

    
}
