<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
    */

    public function up(): void
    { 
        
        Schema::create('alfabetizadoresturmas', function (Blueprint $table) {
            // 
            $table->id();
            $table->foreignId('municipio_id')->constrained()->cascadeOnDelete();    // 
            $table->foreignId('parceiro_id')->constrained()->cascadeOnDelete();    // Parceiro em que pertence
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();       // Quem cadastrou
           
            $table->foreignId('escola_id')->constrained()->cascadeOnDelete();   //
            
            $table->string('nome_do_responsavel',100); // Se é primário é alfabterizador
            $table->string('data_de_nascimento',100);
            $table->text('morada')->nullable();
            $table->string('bilhete',15); //006675055LA048
            $table->string('foto_do_bilhete_frontal',255);
            $table->string('foto_do_bilhete_trazeira',255);
           
            $table->string('habilitcao',80);
            $table->string('foto_da_habilitcao',255);

            $table->string('telefone_do_responsavel',9);
            $table->string('email_do_responsavel',80)->nullable();
            $table->integer('anos_como_alfabetizador')->default(0);

           
            $table->integer('ano_da_ultima_formacao')->nullable();
            $table->string('organizador',200)->nullable();
            
            $table->string('funcionario_publico',100)->default("não"); // sim; não.
            $table->string('numero_de_agente')->nullable(); //

            $table->foreignId('banco_id')->constrained()->cascadeOnDelete();
            $table->string('nib',17);
            $table->string('iban',21); // AO06.NIB
            $table->string('comprovativo',255);


            $table->foreignId('subnivei_id')->constrained()->cascadeOnDelete();  // Módulo (I, II, III) ou // ANO DO (1º CILCO) OU // ANO DO (2º CILCO)
            $table->foreignId('turno_id')->constrained()->cascadeOnDelete(); // manhã, tarde, noite
            $table->foreignId('referencia_id')->constrained()->cascadeOnDelete(); // Projecto, forum, âmbito em que a turma pertence
            
            $table->date('data_de_inicio');
            
            $table->integer('alunos_mf_15_a_19_anos');
            $table->integer('alunos_f_15_a_19_anos');

            $table->integer('alunos_mf_20_a_24_anos');
            $table->integer('alunos_f_20_a_24_anos');

            $table->integer('alunos_mf_25_a_29_anos');
            $table->integer('alunos_f_25_a_29_anos');

            $table->integer('alunos_mf_30_a_34_anos');
            $table->integer('alunos_f_30_a_34_anos');

            $table->integer('alunos_mf_35_a_39_anos');
            $table->integer('alunos_f_35_a_39_anos');

            $table->integer('alunos_mf_40_a_44_anos');
            $table->integer('alunos_f_40_a_44_anos');

            $table->integer('alunos_mf_45_a_49_anos');
            $table->integer('alunos_f_45_a_49_anos');

            $table->integer('alunos_mf_50_a_54_anos');
            $table->integer('alunos_f_50_a_54_anos');

            $table->integer('alunos_mf_55_a_59_anos');
            $table->integer('alunos_f_55_a_59_anos');

            $table->integer('alunos_mf_60_a_64_anos');
            $table->integer('alunos_f_60_a_64_anos');

            $table->integer('alunos_mf_65_ou_mais_anos');
            $table->integer('alunos_f_65_ou_mais_anos');

            $table->integer('total_alunos_mf');
            $table->integer('total_alunos_f');
            $table->integer('total_alunos_m');

            $table->string('foto_da_lista',255);
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
    */

    public function down(): void
    {
        Schema::dropIfExists('alfabetizadoresturmas');
    }
};
