<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('aproveitamentos', function (Blueprint $table) {
            $table->id();
            $table->string('anolectivo')->unique();
            $table->string('numero')->nullable();
            $table->string('nota')->nullable();
            $table->string('datadeinicio');
            $table->string('datadetermino');
            $table->string('estado'); // Disponível, Arquivado
            $table->foreignId('entidade_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('aproveitamentos');
    }
};
