<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pautas', function (Blueprint $table) {
            $table->foreignId('alfabetizadoresturma_id')->constrained()->cascadeOnDelete();
            $table->foreignId('aproveitamento_id')->constrained()->cascadeOnDelete();
            $table->string('estado'); // Disponível, Arquivado
            
            $table->float('aprovados_mf'); //
            $table->float('aprovados_f'); //
            $table->float('reprovados_mf'); //
            $table->float('reprovados_f'); //
            $table->float('desistentes_mf'); //
            $table->float('desistentes_f'); //
            
            $table->float('alunos_matriculados_mf'); //
            $table->float('alunos_matriculados_f'); //

            $table->string('foto_pauta_frontal',255); // 
            $table->string('foto_pauta_trazeira',255)->nullable(); // 
            
            $table->timestamps();
            $table->primary(['alfabetizadoresturma_id', 'aproveitamento_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pautas');
    }
};
