<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('registos', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('municipio_id')->constrained()->cascadeOnDelete(); //
            $table->foreignId('province_id')->constrained()->cascadeOnDelete(); //

            $table->text('descricao');
            $table->text('nota')->nullable();

            $table->foreignId('categoria_id')->constrained()->cascadeOnDelete();
            $table->foreignId('departamento_id')->constrained()->cascadeOnDelete();
            
            $table->string('anexo')->nullable();
            $table->string('anexo1')->nullable();
            $table->string('anexo2')->nullable();
            $table->string('anexo3')->nullable();

            $table->foreignId('entidade_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); // criado por
            
            $table->string('estado')->default("Validado"); // Pendente, Validado, Anulado
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('registos');
    }
};
