<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        
        Schema::table('escolas', function (Blueprint $table) {
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); //
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('escolas', function (Blueprint $table) {
            $table->dropForeign('users_user_id_foreign'); // A referência
            $table->dropColumn('user_id'); // A coluna
        });
    }
};
