
@extends('../layouts.navigation')
@section('content')
   
<main id="main" class="main">

     <!-- Page Title -->
     <div class="pagetitle">
        <h1>Dashboard</h1>
        <nav>
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item active">Dados Analíticos</li>
          </ol>
        </nav>
      </div>
      <!-- End Page Title -->
        <section class="section">
            <div class="row">

                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Aproveitamento</h5>
                                <style>
                                    form { display: flex; flex-wrap: wrap; gap: 10px; }
                                    label { font-weight: bold; }
                                    select, button { padding: 8px; }
                                    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                                    th { background-color: #f4f4f4; }
                                </style>

                                    <h2>Filtrar Aproveitamentos</h2>

                                <form method="GET" action="{{ url('dashboard') }}">
                                    @csrf

                                    <label for="ano_id">Ano Letivo:</label>
                                    <select id="ano_id" name="ano_id">
                                        <option value="">Todos</option>
                                        @foreach ($anos as $ano)
                                            <option value="{{ $ano->id }}" {{ request('ano_id') == $ano->id ? 'selected' : '' }}>
                                                {{ $ano->anolectivo }}
                                            </option>
                                        @endforeach
                                    </select>

                                    <label for="provincia_id">Província:</label>
                                    <select id="provincia_id" name="provincia_id">
                                        <option value="">Todas</option>
                                        @foreach ($provincias as $provincia)
                                            <option value="{{ $provincia->id }}" {{ request('provincia_id') == $provincia->id ? 'selected' : '' }}>
                                                {{ $provincia->nome }}
                                            </option>
                                        @endforeach
                                    </select>

                                    <label for="municipio_id">Município:</label>
                                    <select id="municipio_id" name="municipio_id">
                                        <option value="">Todos</option>
                                        @foreach ($municipios as $municipio)
                                            <option value="{{ $municipio->id }}" {{ request('municipio_id') == $municipio->id ? 'selected' : '' }}>
                                                {{ $municipio->nome }}
                                            </option>
                                        @endforeach
                                    </select>

                                    <label for="turma_id">Turma:</label>
                                    <select id="turma_id" name="turma_id">
                                        <option value="">Todas</option>
                                        @foreach ($turmas as $turma)
                                            <option value="{{ $turma->id }}" {{ request('turma_id') == $turma->id ? 'selected' : '' }}>
                                                {{ $turma->nome_do_responsavel }}
                                            </option>
                                        @endforeach
                                    </select>

                                    <button type="submit">Filtrar</button>
                                </form>

                    <h3>Resultados:</h3>
                    <table>
                        <thead>
                            <tr>
                                <th>Município</th>
                                <th>Ano Letivo</th>
                                <th>Matriculados (MF)</th>
                                <th>Matriculados (F)</th>
                                <th>Aprovados (MF)</th>
                                <th>Aprovados (F)</th>
                                <th>Reprovados (MF)</th>
                                <th>Reprovados (F)</th>
                                <th>Desistentes (MF)</th>
                                <th>Desistentes (F)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($resultados as $row)
                                <tr>
                                    <td>{{ $row->municipio }}</td>
                                    <td>{{ $row->anolectivo }}</td>
                                    <td>{{ $row->total_matriculados_mf }}</td>
                                    <td>{{ $row->total_matriculados_f }}</td>
                                    <td>{{ $row->total_aprovados_mf }}</td>
                                    <td>{{ $row->total_aprovados_f }}</td>
                                    <td>{{ $row->total_reprovados_mf }}</td>
                                    <td>{{ $row->total_reprovados_f }}</td>
                                    <td>{{ $row->total_desistentes_mf }}</td>
                                    <td>{{ $row->total_desistentes_f }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                


                           
                        </div>
                    </div>     
                </div>
                
                <div class="col-lg-8">
                  <div class="card">
                    <div class="card-body">
                      <h5 class="card-title">Registos por Categoria</h5>
                        <select id="filtroCategoria" class="form-select">
                            <option value="todas">Todas</option>
                            @foreach ($RegistoPorCategoria as $item)
                                <option value="{{ $item->categoria }}">{{ $item->categoria }}</option>
                            @endforeach
                        </select>
                      <!-- Bar Chart -->
                      <div id="barChart_registos_por_categoria" style="min-height: 400px;" class="echart"></div>
        
                      <script>
                        document.addEventListener("DOMContentLoaded", () => {
                            let dados = @json($RegistoPorCategoria);
                            
                            let categorias = dados.map(item => item.categoria);
                            let valores = dados.map(item => item.qnt);
                        
                            let chart = echarts.init(document.querySelector("#barChart_registos_por_categoria"));
                        
                            function atualizarGrafico(filtro) {
                                let categoriasFiltradas = [];
                                let valoresFiltrados = [];
                        
                                if (filtro === "todas") {
                                    categoriasFiltradas = categorias;
                                    valoresFiltrados = valores;
                                } else {
                                    dados.forEach(item => {
                                        if (item.categoria === filtro) {
                                            categoriasFiltradas.push(item.categoria);
                                            valoresFiltrados.push(item.qnt);
                                        }
                                    });
                                }
                        
                                chart.setOption({
                                    xAxis: {
                                        type: 'category',
                                        data: categoriasFiltradas,
                                        axisLabel: { rotate: 10,fontSize: 7 }
                                    },
                                    yAxis: { type: 'value' },
                                    series: [{
                                        data: valoresFiltrados,
                                        type: 'bar'
                                    }]
                                });
                            }
                        
                            atualizarGrafico("todas");
                        
                            document.getElementById("filtroCategoria").addEventListener("change", function() {
                                atualizarGrafico(this.value);
                            });
                        });
                      </script>
                      <!-- End Bar Chart -->
        
                    </div>
                  </div>
                </div>

                <div class="col-lg-4">
                    <div class="card">
                      <div class="card-body">
                        <h5 class="card-title">Registos por Departamento</h5>
                        <select id="filtroDepartamento" class="form-select">
                            <option value="todas">Todos</option>
                            @foreach ($RegistoPorDepartamento as $item)
                                <option value="{{ $item->cod_dpto }}">{{ $item->cod_dpto }}</option>
                            @endforeach
                        </select>
                        <!-- Bar Chart -->
                        <div id="barChart_registos_por_departamento" style="min-height: 400px;" class="echart"></div>
          
                        <script>
                            document.addEventListener("DOMContentLoaded", () => {
                                let dados = @json($RegistoPorDepartamento);
                                
                                let departamentos = dados.map(item => item.cod_dpto);
                                let valores = dados.map(item => item.qnt);
                            
                                let chart = echarts.init(document.querySelector("#barChart_registos_por_departamento"));
                            
                                function atualizarGrafico(filtro) {
                                    let departamentosFiltradas = [];
                                    let valoresFiltrados = [];
                            
                                    if (filtro === "todas") {
                                        departamentosFiltradas = departamentos;
                                        valoresFiltrados = valores;
                                    } else {
                                        dados.forEach(item => {
                                            if (item.cod_dpto === filtro) {
                                                departamentosFiltradas.push(item.cod_dpto);
                                                valoresFiltrados.push(item.qnt);
                                            }
                                        });
                                    }
                            
                                    chart.setOption({
                                        xAxis: {
                                            type: 'category',
                                            data: departamentosFiltradas,
                                            axisLabel: { rotate: 10,fontSize: 7 }
                                        },
                                        yAxis: { type: 'value' },
                                        series: [{
                                            data: valoresFiltrados,
                                            type: 'bar'
                                        }]
                                    });
                                }
                            
                                atualizarGrafico("todas");
                            
                                document.getElementById("filtroDepartamento").addEventListener("change", function() {
                                    atualizarGrafico(this.value);
                                });
                            });
                          </script>
                          <!-- End Bar Chart -->
          
                      </div>
                    </div>
                  </div>
                
              </div>
        </section>

  </main>
  <!-- End #main -->

  

@endsection


