<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Alterar entidade') }}
        </h2>
    </x-slot>
    
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <form action="{{route('entidade.edit', ['valor'=>$Entidade->id, 'ok'=>1])}}" method="POST">
                        
                        <div class="w-full mb-6">
                            <label for="">Nome*</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="nome" id="nome" value="{{$Entidade->nome}}">
                            @error('nome')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Descrição</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="descricao" id="descricao" value="{{$Entidade->descricao}}">
                            @error('descricao')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Sobre</label>
                            <textarea class="w-full border border-gray-700 rounded" type="text" name="sobre" id="sobre" rows="2">{{$Entidade->sobre}}</textarea>
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Telefone</label>
                            <input class="w-full border border-gray-700 rounded" type="tel" name="telefone" id="telefone" minlength="9" maxlength="9" value="{{$Entidade->telefone}}">
                            @error('telefone')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        
                        <div class="w-full mb-6">
                            <label for="">Email</label>
                            <input class="w-full border border-gray-700 rounded" type="email" name="email" id="email" value="{{$Entidade->email}}">
                            @error('email')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        
                        <div class="w-full mb-6">
                            <label for="">Fundação</label>
                            <input class="w-full border border-gray-700 rounded" type="date" name="fundacao" id="fundacao" value="{{$Entidade->fundacao}}">
                            @error('fundacao')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        
                       
                        <button class="px-4 py-2 rounded border border-green-900 bg-green-700 text-white hover:bg-green-900 
                        transition duration-300 ease-in-out" type="submit">Salvar</button>
                        @csrf
                        @method('PUT')
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
