<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Alterar escola') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <form method="POST" enctype="multipart/form-data" id="upload"  action="{{route('escola.edit', ['valor'=>$escola->id, 'ok'=>1])}}">
                        
                        @if (session('status'))
                            <div class="w-full my-4 p-2" style="color: green">
                                {{ session('status') }}
                            </div>
                        @endif 

                        <div class="w-full mb-6">
                            <label for="">Município*</label>
                            <select value="{{ old('municipio') }}" class="w-full border border-gray-700 rounded" required name="municipio" id="municipio">
                                @forelse ($municipios as $item)
                                    <option @if ($escola->municipio_id == $item->idmunicipio) @selected(true) @endif value="{{$item->idmunicipio}}"> 
                                        {{$item->nome_provincia}} - {{$item->nome_municipio}}
                                    </option>
                                @empty
                                    <option @disabled(true) value="">Nenhuma província - município cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('provincia') 
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Nome da escola*</label>
                            <input class="w-full border border-gray-700 rounded" required type="text" name="nome" id="nome" value="{{ $escola->nome }}">
                            @error('nome')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Número da escola</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="codigo" id="codigo" value="{{ $escola->numerodaescola }}">
                            @error('codigo')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Nome do Responsável*</label>
                            <input class="w-full border border-gray-700 rounded" type="text" required name="responsavel" id="responsavel" value="{{ $escola->nomedoresponsavel }}">
                            @error('responsavel')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Telefone do Responsável</label>
                            <input class="w-full border border-gray-700 rounded" type="number" name="telefone" id="telefone" value="{{ $escola->telefonedoresponsavel }}">
                            @error('long')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Email do Responsável</label>
                            <input class="w-full border border-gray-700 rounded" type="email" name="email" id="email" value="{{ $escola->emaildoresponsavel }}">
                            @error('email')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Logotipo (PNG, JPEG, JPG)*</label>
                            <span>
                                @if ($escola->logotipo==null or $escola->logotipo=='')
                                        <a href="{{ asset('assets/img/sem-foto.jpg')}}" target="_blank">
                                                <img src="{{asset('assets/img/sem-foto.jpg')}}" style="width: 195px; height: 195px;">
                                        </a>    
                                        @else
                                        <a href="{{asset($escola->logotipo)}}" target="_blank">
                                                <img src="{{ asset($escola->logotipo)}}" style="width: 195px; height: 195px;">
                                        </a>   
                                @endif
                            </span>
                            
                            <input class="w-full border border-gray-700 rounded" type="file" name="photo" id="photo" >
                            @error('photo')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <input type="hidden" name="escola" id="escola" value="{{$escola->id}}">
                        <button class="px-4 py-2 rounded border text-white border-green-900 bg-green-700 hover:bg-green-900 
                        transition duration-300 ease-in-out" type="submit">Salvar</button>
                        @csrf
                        @method('PUT')
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
