<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('escolas') }}
        </h2>
    </x-slot>
        
      <div class="py-12 pt-10">
        
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
           
                <div class="w-full flex justify-end mb-4 pr-8">
                    <a href="{{route('escola.create')}}" class="px-2 py-1 text-white border rounded border-green-900 bg-green-400 text-green transition duration-300 ease-in-out">
                        Novo
                    </a>
                </div>
            
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                @if (session('status'))
                    <div class="w-full my-4 p-2" style="color: green">
                        {{ session('status') }}
                    </div>
                @endif  
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Ordem</th>
                            <th class="font-bold text-left px-4 py-4">logo</th>
                            <th class="font-bold text-left px-4 py-4">Escola</th>
                            <th class="font-bold text-left px-4 py-1">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Responsável</th>
                            <th class="font-bold text-left px-4 py-1">Telefone</th>
                            <th class="font-bold text-left px-4 py-1">Email</th>
                            <th class="font-bold text-left px-4 py-1">Município</th>
                            <th class="font-bold text-left px-4 py-1">Província</th>
                            <th class="font-bold text-left px-4 py-1">Acção</th>
                        </thead>
                        <tbody>
                           <?php $counter=0; ?>
                           @forelse ($escolas as $Item)
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td> 
                                    <td class="font-normal px-4 py-2">
                                        @if ($Item->logotipo==null or $Item->logotipo=='')
                                            <a href="{{ asset('assets/img/sem-foto.jpg')}}" target="_blank">
                                                <img src="{{asset('assets/img/sem-foto.jpg')}}" style="width: 45px; height: 45px;">
                                            </a>    
                                        @else
                                            <a href="{{asset($Item->logotipo)}}" target="_blank">
                                                <img src="{{asset($Item->logotipo)}}" style="width: 45px; height: 45px;">
                                            </a>   
                                        @endif
                                        
                                    </td> 
                                    <td class="font-normal px-4 py-2">{{$Item->nome}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->numerodaescola}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->nomedoresponsavel}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->telefonedoresponsavel}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->emaildoresponsavel}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->nome_municipio}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->nome_provincia}}</td>
                                    <td class="font-normal px-4 py-2">
                                        <div class="flex flex-around gap-2">
                                            <a href="{{route('escola.edit', ['valor'=>$Item->id, 'ok'=>1]) }}" class="px-2 py-1 border rounded border-blue-900 bg-blue-400  text-white transition duration-300 ease-in-out">Alterar</a>
                                            @if (($user->role_id==1 or $user->role_id==2) or $user->id == $Item->responsavelprovincia_id or $user->id == $Item->responsavelmunicipio_id)
                                                <form action="{{route('escola.destroy', ['ok'=>1])}}" method="post">
                                                    <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="px-2 py-1 border rounded border-red-900 bg-red-400 text-white transition duration-300 ease-in-out">Apagar</button>
                                                </form>
                                            @endif 
                                        </div>
                                    </td>
                                </tr> 
                            @empty
                                <tr><td colspan="5">Nenhum registo encontrado...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$escolas->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
