<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Alterar Província') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <form action="{{route('provincia.edit', ['valor'=>$province->id, 'ok'=>1])}}" method="POST">
                        <div class="w-full mb-6">
                            <label for="">Nome*</label>
                            <input class="w-full border border-gray-700 rounded" required type="text" name="nome" id="nome" value="{{ $province->nome }}">
                            @error('nome')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Código</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="codigo" id="codigo" value="{{ $province->codigo }}">
                            @error('codigo')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Latitude</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="lat" id="lat" value="{{ $province->latitude }}">
                            @error('lat')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Longitude</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="long" id="long" value="{{ $province->longitude }}">
                            @error('long')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Precisão (Metros)</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="precision" id="precision" value="{{ $province->precision }}">
                            @error('precision')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Responsável *</label>
                            <select class="w-full border border-gray-700 rounded" required name="user" id="user">
                                @forelse ($users as $item)
                                    <option @if ($province->user_id == $item->id) @selected(true) @endif value="{{$item->id}}">{{$item->name}} ({{$item->role}})</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum usuário cadastrado</option>
                                @endforelse
                            </select>
                            @error('user')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <button class="px-4 py-2 rounded border text-white border-green-900 bg-green-700 hover:bg-green-900 
                        transition duration-300 ease-in-out" type="submit">Salvar</button>
                        @csrf
                        @method('PUT')
                    </form>
                    
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
