<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Províncias') }}
        </h2>
    </x-slot>
        
    
    
      <div class="py-12 pt-10">
        
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if ($user->role_id==1 or $user->role_id==2)
                <div class="w-full flex justify-end mb-4 pr-8">
                    <a href="{{route('provincia.create')}}" class="px-2 py-1 text-white border rounded border-green-900 bg-green-400 text-green transition duration-300 ease-in-out">
                        Nova Província
                    </a>
                </div>
            @endif
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Província</th>
                            <th class="font-bold text-left px-4 py-1">Código</th>
                            <th class="font-bold text-left px-4 py-1">Responsável</th>
                            <th class="font-bold text-left px-4 py-1">Criado em</th>
                            <th class="font-bold text-left px-4 py-1">Acção</th>
                        </thead>
                        <tbody>
                           <?php $counter=0; ?>
                           @forelse ($provinces as $Item)
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td>  
                                    <td class="font-normal px-4 py-2">{{$Item->nome}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->codigo}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->name}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->created_at}}<br>{{$Item->updated_at}}</td>
                                    <td class="font-normal px-4 py-2">
                                        <div class="flex flex-around gap-2">
                                            @if ($user->role_id==1 or $user->role_id==2)
                                                    <a href="{{route('provincia.edit', ['valor'=>$Item->id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-blue-900 bg-blue-400  text-white transition duration-300 ease-in-out">Alterar</a>
                                                    <form action="{{route('provincia.destroy', ['ok'=>1])}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="px-2 py-1 border rounded border-red-900 bg-red-400 text-white transition duration-300 ease-in-out">Apagar</button>
                                                    </form>
                                            @endif 
                                        </div>
                                    </td>
                                </tr> 
                            @empty
                                <tr><td colspan="5">Nenhuma Provincia cadastrada...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$provinces->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
