@extends('layouts.navigation')
@section('content')
   
  <main id="main" class="main">
    
    <!-- Page Title -->
    <div class="pagetitle">
      <h1>Registos</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{ route('registo.index') }}">Registos</a></li>
          <li class="breadcrumb-item active">Registos</li>
        </ol>
      </nav>
    </div>
    <!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Registos</h5>
              <div class="row">
                  <div class="col-lg-8">
                      @if (session('status'))
                          <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="bi bi-check-circle me-1"></i>
                            {{ session('status') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                          </div>
                      @endif
                  </div>
                  <div class="col-lg-4" style="text-align: right; padding-right: 2%">
                    @if ($user->role_id==1 or $user->role_id==2)
                        <a href="{{route('registo.create')}}" data-bs-toggle="tooltip" data-bs-placement="top" title="Adicionar um novo registo." class="btn btn-dark"><i class="bi bi-folder-plus"></i></a>
                    @endif
                  </div>
              </div>


              <!-- Table with stripped rows -->
              <table class="table datatable responsive" >
                <thead>
                  <tr style="font-size: 10px">
                    <th></th>
                    <th>Categoria</th>
                    <th>Descrição</th>
                    <th>Departamento</th>
                    <th>Província</th>
                    <th>Município</th>
                    <th colspan="4">Acção</th>
                  </tr>
                </thead>
                <tbody>
                    <?php 
                        $counter=0; 
                    ?>
                    @foreach ($registos as $Item)
                    <tr> 
                        <td>
                            @if ($Item->total_vistos>0)
                              <a href="{{route('registo.show', ['valor'=>$Item->id, 'ok'=>1]) }}" data-bs-toggle="tooltip" data-bs-placement="top" title="Abrir a lista de <?php if ($Item->total_vistos==1){ echo 'visualização'; }else{echo 'visualizações'; } ?>">
                                <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i> {{ $Item->total_vistos }}</span>
                              </a>
                            @else
                              <span class="badge bg-danger"><i class="bi bi-check-circle me-1"></i> {{ $Item->total_vistos }}</span>
                            @endif
                        </td>
                        <td class="" style="font-size: 10px">{{$Item->categoria}}</td>
                        <td class="" style="font-size: 10px">{{$Item->descricao}} <br> {{$Item->nota}}</td>
                        <td class="" style="font-size: 10px">{{$Item->departamento}}</td>
                        <td class="" style="font-size: 10px">{{$Item->nome_provincia}}</td>
                        <td class="" style="font-size: 10px">{{$Item->nome_municipio}}</td>
                        <td style="width: 22%;">
                            <form style="display: inline-block;" action="{{route('registo.visto', ['ok'=>1])}}" method="post">
                                <input type="hidden" name="valor" value="{{ $Item->id }}">
                                @csrf
                                <button data-bs-toggle="tooltip" data-bs-placement="top" title="Marcar como visto." type="submit" class="btn btn-sm btn-success"><i class="bi bi-check-circle"></i></button>
                            </form>
                            <a  @if ($Item->anexo) href="{{ url("storage/{$Item->anexo}" ) }}" @else href="#" @endif  data-bs-toggle="tooltip" data-bs-placement="top" title="Abrir o anexo 1." type="button" class="btn btn-sm btn-dark"><i class="bi bi-paperclip"></i></a>
                            <a  @if ($Item->anexo1) href="{{ url("storage/{$Item->anexo1}" ) }}" @else href="#" @endif  data-bs-toggle="tooltip" data-bs-placement="top" title="Abrir o anexo 2." type="button" class="btn btn-sm btn-dark"><i class="bi bi-paperclip"></i></a>
                            @if (($user->role_id=='1' or $user->role_id=='2') or ($user->id == $Item->user_id))
                                <a href="{{route('registo.edit', ['valor'=>$Item->id, 'ok'=>1]) }}" data-bs-toggle="tooltip" data-bs-placement="top" title="Alterar o registo." type="button" class="btn btn-sm btn-info"><i class="bi bi-pencil"></i></a>
                            @endif
                            @if (($user->role_id=='1' or $user->role_id=='2'))
                                <form style="display: inline-block;" action="{{route('registo.destroy', ['ok'=>1])}}" method="post">
                                  <input type="hidden" name="valor" value="{{ $Item->id }}">
                                  @csrf
                                  @method('DELETE')
                                  <button data-bs-toggle="tooltip" data-bs-placement="top" title="Deletar permanentemente este registo." type="submit" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                                </form>
                            @endif
                        
                        </td> 
                        
                         
                    </tr> 

                    @endforeach
                </tbody>
              </table>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->

@endsection