@extends('../layouts.navigation')
@section('content')
   
<main id="main" class="main">

     <!-- Page Title -->
     <div class="pagetitle">
        <h1>Turmas</h1>
        <nav>
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('turma.index') }}">Turmas</a></li>
            <li class="breadcrumb-item active">Novo</li>
          </ol>
        </nav>
      </div>
      <!-- End Page Title -->
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                    <h5 class="card-title">Nova Turma</h5>
                    <P>
                      @if (session('status'))
                          <div class="alert alert-success alert-dismissible fade show" role="alert">
                              {{ session('status') }}
                          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                          </div>
                      @endif

                      @if (session('error'))
                          <div class="alert alert-danger alert-dismissible fade show" role="alert">
                              {{ session('status') }}
                          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                          </div>
                      @endif
                    </P>
                        <!-- Multi Columns Form -->
                        <form class="row g-3" method="POST" enctype="multipart/form-data" id="upload" action="{{route('turma.create')}}">
                            
                          <div class="col-md-4">
                              <label for="municipio" class="form-label">Província - Município*</label>
                              <select value="{{ old('municipio') }}" class="form-control" required name="municipio" id="municipio">
                                    <option @disabled(true) value="" selected>Selecione uma Província - Município</option>
                                    @forelse ($municipios as $item)
                                      <option value="{{$item->id}}">{{$item->nome_province}} - {{$item->nome_municipio}}</option>
                                  @empty
                                      <option @disabled(true) value="">Nenhum município cadastrado</option>
                                  @endforelse
                              </select>
                              @error('municipio') 
                                  <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                  </div>
                              @enderror
                          </div>
                          <div class="col-md-4">
                            <label for="parceiro" class="form-label">Parceiros*</label>
                            <select value="{{ old('parceiro') }}" class="form-control" required name="parceiro" id="parceiro">
                                <option @disabled(true) value="" selected>Selecione um Parceiro</option>
                                @forelse ($parceiros as $item)
                                    <option value="{{$item->id}}">( {{$item->nome_province}} - {{$item->nome_municipio}} ) - {{$item->nome}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhuma Parceiro cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('parceiro') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>
                        
                        <div class="col-md-4">
                            <label for="escola" class="form-label">Escolas*</label>
                            <select value="{{ old('escola') }}" class="form-control" required name="escola" id="escola">
                                <option @disabled(true) value="" selected>Selecione uma Escola</option>
                                @forelse ($escolas as $item)
                                    <option value="{{$item->id}}">( {{$item->nome_province}} - {{$item->nome_municipio}} ) - {{$item->nome}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum escola cadastrada</option>
                                @endforelse
                                
                            </select>
                            @error('escola') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-8">
                            <label for="responsavel" class="form-label">Nome do Responsável da Turma (Alfabetizador / Professor)*</label>
                            <input placeholder="Informe o Nome do Responsável da Turma (Alfabetizador / Professor)" class="form-control" max="100" type="text" name="responsavel" id="responsavel" required value="{{ old('responsavel') }}">
                            @error('responsavel')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="nascimento" class="form-label">Data de Nascimento*</label>
                            <input placeholder="nascimento" class="form-control" type="date" required name="nascimento" id="nascimento" value="{{ old('nascimento') }}">
                            @error('nascimento')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-8">
                            <label for="morada" class="form-label">Endereço ou Morada do Alfabetizador</label>
                            <input class="form-control" type="text" placeholder="Informe o Endereço ou Morada do Alfabetizador" required name="morada" id="morada" value="{{ old('morada') }}">
                            @error('morada')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-8">
                            <label for="indentificacao" class="form-label">Nº do Documento de Indentificação (Bilhete ou Passaporte)*</label>
                            <input placeholder="Informe o Nº do Documento de Indentificação (Bilhete ou Passaporte)" class="form-control" required type="text" name="indentificacao" id="indentificacao" value="{{ old('indentificacao') }}">
                            @error('indentificacao')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="foto_id_frontal" class="form-label">Fotografia da Parte frontal (PNG, JPEG, JPG)*</label>
                            <input class="form-control" type="file" required name="foto_id_frontal" id="foto_id_frontal" >
                            @error('foto_id_frontal')
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="foto_id_trazeira" class="form-label">Fotografia da Parte Trazeira (PNG, JPEG, JPG)*</label>
                            <input class="form-control" type="file" required name="foto_id_trazeira" id="foto_id_trazeira" >
                            @error('foto_id_trazeira')
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <img id="preview_foto_id_frontal" src="" alt="" srcset="">
                        </div>

                        <div class="col-md-6">
                            <img id="preview_foto_id_trazeira" src="" alt="" srcset="">
                        </div>
                        

                        <div class="col-md-6">
                            <label for="habilitcao" class="form-label">Habilitadção do Responsável da turma*</label>
                            <select value="{{ old('habilitcao') }}" class="form-control" required name="habilitcao" id="habilitcao">
                                <option @disabled(true) value="" selected>Selecione uma habilitação</option>
                                <option @disabled(false) value="MENOS QUE A 6ª CLASSE" >MENOS QUE A 6ª CLASSE</option>
                                <option @disabled(false) value="ENSINO PRIMÁRIO COMPLETO" >ENSINO PRIMÁRIO COMPLETO</option>
                                <option @disabled(false) value="1º CICLO DO ENSINO SECUNDÁRIO" >1º CICLO DO ENSINO SECUNDÁRIO</option>
                                <option @disabled(false) value="2º CICLO DO ENSINO SECUNDÁRIO" >2º CICLO DO ENSINO SECUNDÁRIO</option>
                                <option @disabled(false) value="GRADUAÇÃO COMPLETA (BACHARELADO COMPLETO/ LICENCIATURA COMPLETA)" >GRADUAÇÃO COMPLETA (BACHARELADO COMPLETO/ LICENCIATURA COMPLETA)</option>
                                <option @disabled(false) value="PÓS-GRADUAÇÃO COMPLETA (MESTRADO COMPLETO/ DOUTORAMENTO)" >PÓS-GRADUAÇÃO COMPLETA (MESTRADO COMPLETO/ DOUTORAMENTO)</option>
                                <option @disabled(false) value="NÃO APLICÁVEL" >NÃO APLICÁVEL</option>

                            </select>
                            @error('habilitcao') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="foto_da_habilitcao" class="form-label">Fotografia Do Documento (PNG, JPEG, JPG)*</label>
                            <input class="form-control" type="file" required name="foto_da_habilitcao" id="foto_da_habilitcao" >
                            @error('foto_da_habilitcao')
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>
                        <div class="col-md-8">
                            <img id="preview_foto_da_habilitcao" src="" alt="" srcset="">
                        </div>

                        <div class="col-md-6">
                            <label for="telefone" class="form-label">Telefone*</label>
                            <input placeholder="Informe o Telefone do Responsável da Turma (Alfabetizador / Professor)" class="form-control" type="tel" name="telefone" id="telefone" required value="{{ old('telefone') }}">
                            @error('telefone')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="email" class="form-label">Email</label>
                            <input placeholder="Informe o Email Responsável da Turma (Alfabetizador / Professor)" class="form-control" type="email" name="email" id="email" value="{{ old('email') }}">
                            @error('email')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>


                        <div class="col-md-3">
                            <label for="anos" class="form-label">Anos de Experiência*</label>
                            <input placeholder="Anos como Alfabetizador/Professor" class="form-control" type="number" min="0" max="70" name="anos" id="anos" required value="{{ old('anos') }}">
                            @error('anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="ano" class="form-label">Ano última formação</label>
                            <input placeholder="Ano da última formação" class="form-control" type="number" name="ano" id="ano" value="{{ old('ano') }}">
                            @error('ano')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="organizador" class="form-label">Organizado por?*</label>
                            <input placeholder="Informe quem organizou a última formação" class="form-control" type="text" name="organizador" id="organizador" maxlength="200" required value="{{ old('organizador') }}">
                            @error('organizador')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="organizador" class="form-label">É funcioná Público?*</label>
                            <br><span>
                                <input onchange="ChangAgent();" class="form-check-input" type="radio" name="funcionario_publico" id="funcionario_publico1" value="sim" >
                                <label class="form-check-label" for="funcionario_publico1">
                                Sim
                                </label>
                            </span>
                            <span>
                                <input onchange="ChangAgent();" class="form-check-input" type="radio" name="funcionario_publico" id="funcionario_publico2" value="não" checked>
                                <label class="form-check-label" for="funcionario_publico2">
                                Não
                                </label>
                            </span>
                        </div>
                        <div class="col-md-6">
                            <label for="agente" class="form-label">Número de Agente*</label>
                            <input class="form-control" type="text" name="agente" id="agente" maxlength="200" required value="{{ old('agente') }}">
                            @error('agente')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button"  class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <script>
                            ChangAgent();
                            function ChangAgent(){
                                var valor = document.getElementById("funcionario_publico1").checked
                                if(!valor){
                                    document.getElementById("agente").disabled=true;
                                    document.getElementById("agente").required=false;
                                    
                                }else{
                                    document.getElementById("agente").disabled=false;
                                    document.getElementById("agente").required=true;
                                }
                            }
                            
                        </script>



                        <div class="col-md-6">
                            <label for="banco" class="form-label">Banco*</label>
                            <select value="{{ old('banco') }}" class="form-control" required name="banco" id="banco">
                                <option @disabled(true) value="" selected>Selecione um Banco</option>
                                @forelse ($bancos as $item)
                                    <option value="{{$item->id}}">{{$item->nome}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum Banco cadastrada</option>
                                @endforelse
                                
                            </select>
                            @error('banco') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>


                        <div class="col-md-6">
                            <label for="nib" class="form-label">Número Internacional Bancário (IBAN)*</label>
                            <input class="form-control" type="number" name="nib" id="nib" maxlength="17" required value="{{ old('nib') }}">
                            @error('nib')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button"  class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="comprovativo" class="form-label">Comprovativo Bancário (PNG, JPEG, JPG)*</label>
                            <input class="form-control" type="file" required name="comprovativo" id="comprovativo" >
                            @error('comprovativo')
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <img id="preview_comprovativo" src="" alt="" srcset="">
                        </div>

                        <div class="col-md-2">
                          <label for="anolectivo" class="form-label">Ano lectivo*</label>
                          <select value="{{ old('anolectivo') }}" class="form-control" required name="anolectivo" id="anolectivo">
                              <option @disabled(true) value="" selected>Selecione o Ano Lectivo da Turma</option>
                              @forelse ($anolectivos as $item)
                                  <option value="{{$item->id}}">{{$item->anolectivo }}</option>
                              @empty
                                  <option @disabled(true) value="">Nenhum um ano lectivo</option>
                              @endforelse
                              
                          </select>
                          @error('anolectivo') 
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                  {{ $message }}
                                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                          @enderror
                      </div>
                        
                        <div class="col-md-4">
                            <label for="nivel_de_ensino" class="form-label">Nível de Ensino (Módulo ou Ano)*</label>
                            <select onchange="MudarCiclo();" value="{{ old('nivel_de_ensino') }}" class="form-control" required name="nivel_de_ensino" id="nivel_de_ensino">
                                <option @disabled(true) value="" selected>Selecione um Módulo ou Ano</option>
                                @forelse ($subniveis as $item)
                                    <option value="{{$item->id}}">{{$item->nivel}} - {{$item->subnivel}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum um Módulo ou Ano</option>
                                @endforelse
                                
                            </select>
                            @error('nivel_de_ensino') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>


                        <div class="col-md-3">
                            <label for="turno" class="form-label">Periodo da turma*</label>
                            <select value="{{ old('turno') }}" class="form-control" required name="turno" id="turno">
                                <option @disabled(true) value="" selected>Selecione um Periodo</option>
                                @forelse ($turnos as $item)
                                    <option value="{{$item->id}}">{{$item->turno}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum um Periodo</option>
                                @endforelse
                                
                            </select>
                            @error('turno') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="arranque_da_turma" class="form-label">Data de Início da Turma*</label>
                            <input placeholder="arranque_da_turma" class="form-control" type="date" required name="arranque_da_turma" id="arranque_da_turma" value="{{ old('arranque_da_turma') }}">
                            @error('arranque_da_turma')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-12">
                            <label for="referencia" class="form-label">Referência ou Projecto a que a turma pertence*</label>
                            <select value="{{ old('referencia') }}" class="form-control" required name="referencia" id="referencia">
                                <option @disabled(true) value="" selected>Selecione a Referência ou Projecto</option>
                                @forelse ($projecto_referencias as $item)
                                    <option value="{{$item->id}}">{{$item->referencia}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhuma Referência (Projecto)</option>
                                @endforelse
                                
                            </select>
                            @error('referencia') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_mf_15_a_19_anos" class="form-label" id="label_alunos_mf_15_a_19_anos">Alunos MF 15 à 19 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_15_a_19_anos','alunos_f_15_a_19_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_15_a_19_anos" id="alunos_mf_15_a_19_anos" value="{{ old('alunos_mf_15_a_19_anos') }}">
                            @error('alunos_mf_15_a_19_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_15_a_19_anos" class="form-label" id="label_alunos_f_15_a_19_anos">Alunos F 15 à 19 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_15_a_19_anos','alunos_f_15_a_19_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_15_a_19_anos" id="alunos_f_15_a_19_anos" value="{{ old('alunos_f_15_a_19_anos') }}">
                            @error('alunos_f_15_a_19_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>




                        <div class="col-md-3">
                            <label for="alunos_mf_20_a_24_anos" class="form-label">Alunos MF 20 à 24 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_20_a_24_anos','alunos_f_20_a_24_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_20_a_24_anos" id="alunos_mf_20_a_24_anos" value="{{ old('alunos_mf_20_a_24_anos') }}">
                            @error('alunos_mf_20_a_24_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_20_a_24_anos" class="form-label">Alunos F 20 à 24 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_20_a_24_anos','alunos_f_20_a_24_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_f_20_a_24_anos" id="alunos_f_20_a_24_anos" value="{{ old('alunos_f_20_a_24_anos') }}">
                            @error('alunos_f_20_a_24_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>




                        <div class="col-md-3">
                            <label for="alunos_mf_25_a_29_anos" class="form-label">Alunos MF 25 à 29 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_25_a_29_anos','alunos_f_25_a_29_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_25_a_29_anos" id="alunos_mf_25_a_29_anos" value="{{ old('alunos_mf_25_a_29_anos') }}">
                            @error('alunos_mf_25_a_29_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_25_a_29_anos" class="form-label">Alunos F 25 à 29 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_25_a_29_anos','alunos_f_25_a_29_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_25_a_29_anos" id="alunos_f_25_a_29_anos" value="{{ old('alunos_f_25_a_29_anos') }}">
                            @error('alunos_f_25_a_29_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>




                        <div class="col-md-3">
                            <label for="alunos_mf_30_a_34_anos" class="form-label">Alunos MF 30 à 34 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_30_a_34_anos','alunos_f_30_a_34_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_30_a_34_anos" id="alunos_mf_30_a_34_anos" value="{{ old('alunos_mf_30_a_34_anos') }}">
                            @error('alunos_mf_30_a_34_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_30_a_34_anos" class="form-label">Alunos F 30 à 34 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_30_a_34_anos','alunos_f_30_a_34_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_30_a_34_anos" id="alunos_f_30_a_34_anos" value="{{ old('alunos_f_30_a_34_anos') }}">
                            @error('alunos_f_30_a_34_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>



                        <div class="col-md-3">
                            <label for="alunos_mf_35_a_39_anos" class="form-label">Alunos MF 35 à 39 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_35_a_39_anos','alunos_f_35_a_39_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_35_a_39_anos" id="alunos_mf_35_a_39_anos" value="{{ old('alunos_mf_35_a_39_anos') }}">
                            @error('alunos_mf_35_a_39_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_35_a_39_anos" class="form-label">Alunos F 35 à 39 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_35_a_39_anos','alunos_f_35_a_39_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_35_a_39_anos" id="alunos_f_35_a_39_anos" value="{{ old('alunos_f_35_a_39_anos') }}">
                            @error('alunos_f_35_a_39_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>




                        <div class="col-md-3">
                            <label for="alunos_mf_40_a_44_anos" class="form-label">Alunos MF 40 à 44 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_40_a_44_anos','alunos_f_40_a_44_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_40_a_44_anos" id="alunos_mf_40_a_44_anos" value="{{ old('alunos_mf_40_a_44_anos') }}">
                            @error('alunos_mf_40_a_44_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_40_a_44_anos" class="form-label">Alunos F 40 à 44 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_40_a_44_anos','alunos_f_40_a_44_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_40_a_44_anos" id="alunos_f_40_a_44_anos" value="{{ old('alunos_f_40_a_44_anos') }}">
                            @error('alunos_f_40_a_44_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>
                        

                        <div class="col-md-3">
                            <label for="alunos_mf_45_a_49_anos" class="form-label">Alunos MF 45 à 49 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_45_a_49_anos','alunos_f_45_a_49_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_45_a_49_anos" id="alunos_mf_45_a_49_anos" value="{{ old('alunos_mf_45_a_49_anos') }}">
                            @error('alunos_mf_45_a_49_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_45_a_49_anos" class="form-label">Alunos F 45 à 49 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_45_a_49_anos','alunos_f_45_a_49_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_45_a_49_anos" id="alunos_f_45_a_49_anos" value="{{ old('alunos_f_45_a_49_anos') }}">
                            @error('alunos_f_45_a_49_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>



                        <div class="col-md-3">
                            <label for="alunos_mf_50_a_54_anos" class="form-label">Alunos MF 50 à 54 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_50_a_54_anos','alunos_f_50_a_54_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_50_a_54_anos" id="alunos_mf_50_a_54_anos" value="{{ old('alunos_mf_50_a_54_anos') }}">
                            @error('alunos_mf_50_a_54_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_50_a_54_anos" class="form-label">Alunos F 50 à 54 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_50_a_54_anos','alunos_f_50_a_54_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_50_a_54_anos" id="alunos_f_50_a_54_anos" value="{{ old('alunos_f_50_a_54_anos') }}">
                            @error('alunos_f_50_a_54_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>



                        <div class="col-md-3">
                            <label for="alunos_mf_55_a_59_anos" class="form-label">Alunos MF 55 à 59 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_55_a_59_anos','alunos_f_55_a_59_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_55_a_59_anos" id="alunos_mf_55_a_59_anos" value="{{ old('alunos_mf_55_a_59_anos') }}">
                            @error('alunos_mf_55_a_59_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_55_a_59_anos" class="form-label">Alunos F 55 à 59 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_55_a_59_anos','alunos_f_55_a_59_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_55_a_59_anos" id="alunos_f_55_a_59_anos" value="{{ old('alunos_f_55_a_59_anos') }}">
                            @error('alunos_f_55_a_59_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>



                        <div class="col-md-3">
                            <label for="alunos_mf_60_a_64_anos" class="form-label">Alunos MF 60 à 64 anos*</label>
                            <input onblur="VerifyValue('alunos_mf_60_a_64_anos','alunos_f_60_a_64_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_60_a_64_anos" id="alunos_mf_60_a_64_anos" value="{{ old('alunos_mf_60_a_64_anos') }}">
                            @error('alunos_mf_60_a_64_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_60_a_64_anos" class="form-label">Alunos F 60 à 64 anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_60_a_64_anos','alunos_f_60_a_64_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_60_a_64_anos" id="alunos_f_60_a_64_anos" value="{{ old('alunos_f_60_a_64_anos') }}">
                            @error('alunos_f_60_a_64_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_mf_65_ou_mais_anos" class="form-label">Alunos MF 65 ou Mais anos*</label>
                            <input onblur="VerifyValue('alunos_mf_65_ou_mais_anos','alunos_f_65_ou_mais_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_65_ou_mais_anos" id="alunos_mf_65_ou_mais_anos" value="{{ old('alunos_mf_65_ou_mais_anos') }}">
                            @error('alunos_mf_65_ou_mais_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="alunos_f_65_ou_mais_anos" class="form-label">Alunos F 65 ou Mais anos*</label>
                            <input  onblur="VerifyValue('alunos_mf_65_ou_mais_anos','alunos_f_65_ou_mais_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_65_ou_mais_anos" id="alunos_f_65_ou_mais_anos" value="{{ old('alunos_f_65_ou_mais_anos') }}">
                            @error('alunos_f_65_ou_mais_anos')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>


                        <div class="col-md-3">
                          <label for="alunos_mf_total_anos" class="form-label">Total Alunos MF</label>
                          <input class="form-control" type="number" required min="0" max="80" @readonly(true) @disabled(true) id="alunos_mf_total_anos" value="{{ old('alunos_mf_total_anos') }}">
                          @error('alunos_mf_total_anos')
                            <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                              {{ $message }}
                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                          @enderror
                      </div>

                      <div class="col-md-3">
                          <label for="alunos_f_total_anos" class="form-label">Total Alunos F</label>
                          <input class="form-control" type="number" required min="0" max="80" @readonly(true) @disabled(true) id="alunos_f_total_anos" value="{{ old('alunos_f_total_anos') }}">
                          @error('alunos_f_total_anos')
                            <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                              {{ $message }}
                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                          @enderror
                      </div>


                      <div class="col-md-6">
                        <label for="lista" class="form-label">Fotografia da lista dos Alunos (PNG, JPEG, JPG)</label>
                        <input class="form-control" type="file" name="lista" id="lista" >
                        @error('lista')
                            <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <img id="preview_foto_id_frontal" src="" alt="" srcset="">
                    </div>
                        

                            @csrf
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Salvar</button>
                                <button type="reset" class="btn btn-secondary">Reset</button>
                            </div>
                        </form>
                        <!-- End Multi Columns Form -->

                    </div>
                </div>
            </div>
        </div>
    </section>

  </main>
  <!-- End #main -->


  <script>
        
        var ciclo =  document.getElementById('nivel_de_ensino');
        var label_mf =  document.getElementById('label_alunos_mf_15_a_19_anos');
        var label_f =  document.getElementById('label_alunos_f_15_a_19_anos');
        // 
        function MudarCiclo(){
            if(ciclo.value>3){
                label_mf.innerHTML = "Alunos MF 17 à 19 anos*";
                label_f.innerHTML = "Alunos F 17 à 19 anos*";
            }else{
                label_mf.innerHTML = "Alunos MF 15 à 19 anos*";
                label_f.innerHTML = "Alunos F 15 à 19 anos*";
            }
        }
        
        function VerifyValue(idMF,idF){
            var valorMf = document.getElementById(idMF);
            var valorF = document.getElementById(idF);
            if(Number(valorMf.value)<Number(valorF.value)){
                valorMf.style.borderBlockColor="red";
                valorF.style.borderBlockColor="red";
                //alert("O valor de "+idMF+" deve ser superior a "+idF+". ");
            }else{
                valorMf.style.borderBlockColor="";
                valorF.style.borderBlockColor="";
            }
            Calc_total();   
        }

        var alunos_mf_15_a_19_anos = document.getElementById('alunos_mf_15_a_19_anos');
        var alunos_mf_20_a_24_anos = document.getElementById('alunos_mf_20_a_24_anos');
        var alunos_mf_25_a_29_anos = document.getElementById('alunos_mf_25_a_29_anos');
        var alunos_mf_30_a_34_anos = document.getElementById('alunos_mf_30_a_34_anos');
        var alunos_mf_35_a_39_anos = document.getElementById('alunos_mf_35_a_39_anos');
        var alunos_mf_40_a_44_anos = document.getElementById('alunos_mf_40_a_44_anos');
        var alunos_mf_45_a_49_anos = document.getElementById('alunos_mf_45_a_49_anos');
        var alunos_mf_50_a_54_anos = document.getElementById('alunos_mf_50_a_54_anos');
        var alunos_mf_55_a_59_anos = document.getElementById('alunos_mf_55_a_59_anos');
        var alunos_mf_60_a_64_anos = document.getElementById('alunos_mf_60_a_64_anos');
        var alunos_mf_65_ou_mais_anos = document.getElementById('alunos_mf_65_ou_mais_anos');

        var alunos_f_15_a_19_anos = document.getElementById('alunos_f_15_a_19_anos');
        var alunos_f_20_a_24_anos = document.getElementById('alunos_f_20_a_24_anos');
        var alunos_f_25_a_29_anos = document.getElementById('alunos_f_25_a_29_anos');
        var alunos_f_30_a_34_anos = document.getElementById('alunos_f_30_a_34_anos');
        var alunos_f_35_a_39_anos = document.getElementById('alunos_f_35_a_39_anos');
        var alunos_f_40_a_44_anos = document.getElementById('alunos_f_40_a_44_anos');
        var alunos_f_45_a_49_anos = document.getElementById('alunos_f_45_a_49_anos');
        var alunos_f_50_a_54_anos = document.getElementById('alunos_f_50_a_54_anos');
        var alunos_f_55_a_59_anos = document.getElementById('alunos_f_55_a_59_anos');
        var alunos_f_60_a_64_anos = document.getElementById('alunos_f_60_a_64_anos');
        var alunos_f_65_ou_mais_anos = document.getElementById('alunos_f_65_ou_mais_anos');
        
        
        Calc_total();

        
        function Calc_total(){
                document.getElementById('alunos_mf_total_anos').value = 
                              (alunos_mf_15_a_19_anos.value*1+  
                              alunos_mf_20_a_24_anos.value*1+alunos_mf_25_a_29_anos.value*1+ 
                              alunos_mf_30_a_34_anos.value*1+alunos_mf_35_a_39_anos.value*1+ 
                              alunos_mf_40_a_44_anos.value*1+alunos_mf_45_a_49_anos.value*1+ 
                              alunos_mf_50_a_54_anos.value*1+alunos_mf_55_a_59_anos.value*1+ 
                              alunos_mf_60_a_64_anos.value*1+alunos_mf_65_ou_mais_anos.value*1);
                      
                document.getElementById('alunos_f_total_anos').value = 
                            (alunos_f_15_a_19_anos.value*1+  
                              alunos_f_20_a_24_anos.value*1+alunos_f_25_a_29_anos.value*1+ 
                              alunos_f_30_a_34_anos.value*1+alunos_f_35_a_39_anos.value*1+ 
                              alunos_f_40_a_44_anos.value*1+alunos_f_45_a_49_anos.value*1+ 
                              alunos_f_50_a_54_anos.value*1+alunos_f_55_a_59_anos.value*1+ 
                              alunos_f_60_a_64_anos.value*1+alunos_f_65_ou_mais_anos.value*1);
        }
  </script>

@endsection