@extends('../layouts.navigation')
@section('content')
   
<main id="main" class="main">

     <!-- Page Title -->
      <div class="pagetitle">
        <h1>Turmas</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('turma.index') }}">Turmas</a></li>
                <li class="breadcrumb-item active">Editar</li>
            </ol>
        </nav>
      </div>
      <!-- End Page Title -->
      <P>
        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('status') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
      </P>
      <section class="section profile">
        <div class="row">
          <div class="col-xl-12">
  
            <div class="card">
              <div class="card-body pt-3">
                <!-- Bordered Tabs -->
                <ul class="nav nav-tabs nav-tabs-bordered">
  
                  <li class="nav-item">
                    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#detalhe">Detalhes</button>
                  </li>

                  <li class="nav-item">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#detalhe_estatistica">Estatística Inicial</button>
                  </li>

                  <li class="nav-item">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#detalhe_aproveitamento">Aproveitamento (Pauta)</button>
                  </li>
  
                  <li class="nav-item">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#profile-edit">Editar Turma</button>
                  </li>

                  <li class="nav-item">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#foto-da-lista">Ficha De Matrícula</button>
                  </li>
  
                  <li class="nav-item">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#documentos">Documentos</button>
                  </li>
  
                  
  
                </ul>
                <div class="tab-content pt-2">

                    <div class="tab-pane fade show active detalhe pt-3"  id="detalhe">
                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Província:</label>
                                <div class="col-md-8 col-lg-9">
                                          @foreach ($municipios as $item)
                                              @if ($turma->municipio_id == $item->id)
                                                  <input class="form-control" @readonly(true) value="{{$item->nome_province}}">
                                                  @break;
                                              @else 
                                              
                                              @endif
                                          @endforeach
                                    
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Município:</label>
                                <div class="col-md-8 col-lg-9">
                                          @foreach ($municipios as $item)
                                              @if ($turma->municipio_id == $item->id)
                                                  <input class="form-control" @readonly(true) value="{{$item->nome_municipio}}">
                                                  @break;
                                              @else 
                                              
                                              @endif
                                          @endforeach
                                    
                                </div>
                            </div>


                            <div class="row mb-3">
                              <label class="col-md-4 col-lg-3 col-form-label">Parceiro Social:</label>
                                  <div class="col-md-8 col-lg-9">
                                        @foreach ($parceiros as $item)
                                              @if ($turma->parceiro_id == $item->id)
                                                  <input class="form-control" @readonly(true) value="{{$item->nome}}">
                                                  @break;
                                              @else 
                                              @endif
                                        @endforeach
                                      
                                  </div>
                            </div>


                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Escola de Tutela:</label>
                                <div class="col-md-8 col-lg-9">
                                      @foreach ($escolas as $item)
                                              @if ($turma->escola_id == $item->id)
                                                  <input class="form-control" @readonly(true) value="{{$item->nome}}">
                                                  @break;
                                              @endif
                                      @endforeach
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Nome do Responsável:</label>
                                <div class="col-md-8 col-lg-9">
                                    <input class="form-control" @readonly(true) value="{{ $turma->nome_do_responsavel }}">
                                </div>
                            </div>

                            
                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Endereço:</label>
                                <div class="col-md-8 col-lg-9">
                                    <input class="form-control" @readonly(true) value="{{ $turma->morada }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label  class="col-md-4 col-lg-3 col-form-label">Nº do Documento de Indentificação:</label>
                                <div class="col-md-8 col-lg-9">
                                    <input class="form-control" @readonly(true) value="{{ $turma->bilhete }}">
                                </div>
                            </div>

                          
                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Fotografia do Docmento:</label>
                                <div class="col-md-4 col-lg-4">
                                    <a href="{{ url("storage/$turma->foto_do_bilhete_frontal")  }}" target="_blank" rel="">
                                      <img width="100" height="100" src="{{ url("storage/$turma->foto_do_bilhete_frontal")  }}" alt="" srcset="">
                                    </a>
                                </div>
                                <div class="col-md-4 col-lg-4">
                                    <a href="{{ url("storage/$turma->foto_do_bilhete_trazeira")  }}" target="_blank" rel="">
                                      <img width="100" height="100" src="{{ url("storage/$turma->foto_do_bilhete_trazeira")  }}" alt="" srcset="">
                                    </a>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Habilitadção:</label>
                                <div class="col-md-8 col-lg-9">
                                    <input class="form-control" @readonly(true) value="{{ $turma->habilitcao }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label  class="col-md-4 col-lg-3 col-form-label">Documento de Habilitação:</label>
                                <div class="col-md-8 col-lg-9">
                                    <a href="{{ url("storage/$turma->foto_da_habilitcao")  }}" target="_blank" rel="">
                                      <img width="100" height="100" src="{{ url("storage/$turma->foto_da_habilitcao")  }}" alt="" srcset="">
                                    </a>    
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Telefone:</label>
                                <div class="col-md-8 col-lg-5">
                                    <input class="form-control" @readonly(true) value="{{ $turma->telefone_do_responsavel }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Email:</label>
                                <div class="col-md-8 col-lg-5">
                                    <input class="form-control" @readonly(true) value="{{ $turma->email_do_responsavel }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Anos de Experiência:</label>
                                <div class="col-md-8 col-lg-5">
                                    <input class="form-control" @readonly(true) value="{{ $turma->anos_como_alfabetizador }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Ano da Última Formação:</label>
                                <div class="col-md-8 col-lg-5">
                                    <input class="form-control" @readonly(true) value="{{ $turma->ano_da_ultima_formacao }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Organizado por:</label>
                                <div class="col-md-8 col-lg-9">
                                    <input class="form-control" @readonly(true) value="{{ $turma->organizador }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">É funcioná Público?</label>
                                <div class="col-md-8 col-lg-5">
                                    <input class="form-control" @readonly(true) value="{{ $turma->funcionario_publico }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                              <label class="col-md-4 col-lg-3 col-form-label">Banco:</label>
                                <div class="col-md-8 col-lg-9">
                                    @foreach ( $bancos as $item )
                                        @if ($turma->banco_id==$item->id)
                                            <input class="form-control" @readonly(true) value="{{ $item->nome }}">
                                            @break
                                        @endif
                                    @endforeach
                                  </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Número Internacional Bancário (NIB):</label>
                                <div class="col-md-4 col-lg-4">
                                    <input class="form-control" @readonly(true) value="{{ $turma->nib }}">
                                </div>
                                <div class="col-md-4 col-lg-5">
                                  <input class="form-control" @readonly(true) value="{{ $turma->iban }}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Comprovativo Bancário:</label>
                                <div class="col-md-8 col-lg-9">
                                    <a href="{{ url("storage/$turma->comprovativo")  }}" target="_blank" rel="">
                                        <img width="100" height="100" src="{{ url("storage/$turma->comprovativo")  }}" alt="" srcset="">
                                    </a>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Ano lectivo:</label>
                                <div class="col-md-8 col-lg-5">
                                    @foreach ( $anolectivos as $item )
                                        @if ($turma->ano_id==$item->id)
                                            <input class="form-control" @readonly(true) value="{{ $item->anolectivo }}">
                                            @break
                                        @endif
                                    @endforeach
                                  </div>
                            </div>


                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Nível de Ensino:</label>
                                <div class="col-md-8 col-lg-5">
                                    @foreach ($subniveis as $item)
                                        @if ($turma->subnivei_id==$item->id)
                                            <input class="form-control" @readonly(true) value="{{$item->nivel}}">
                                            @break
                                        @endif
                                    @endforeach
                                  </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Módulo / Ano:</label>
                                <div class="col-md-8 col-lg-5">
                                    @foreach ($subniveis as $item)
                                        @if ($turma->subnivei_id==$item->id)
                                            <input class="form-control" @readonly(true) value="{{$item->subnivel}}">
                                            @break
                                        @endif
                                    @endforeach
                                  </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Turno:</label>
                                <div class="col-md-8 col-lg-5">
                                    @foreach ($turnos as $item)
                                        @if ($turma->turno_id==$item->id)
                                            <input class="form-control" @readonly(true) value="{{$item->turno}}">
                                            @break
                                        @endif
                                    @endforeach
                                  </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-3 col-form-label">Data de Início da Turma:</label>
                                <div class="col-md-8 col-lg-5">
                                    <input class="form-control" @readonly(true) value="{{$turma->data_de_inicio}}">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-md-4 col-lg-12 col-form-label">Referência ou Projecto a que a turma pertence:</label>
                                <div class="col-md-8 col-lg-12">
                                      @forelse ($projecto_referencias as $item)
                                          @if ($turma->referencia_id == $item->id)
                                                  <input class="form-control" @readonly(true) value="{{$item->referencia}}">
                                              @break
                                          @endif
                                      @empty
                                          <input class="form-control" @readonly(true) value="">
                                      @endforelse
                                </div>
                            </div>
                    </div>
                    <div class="tab-pane fade show detalhe_estatistica pt-3"  id="detalhe_estatistica">
                        <h6 class="card-title">Alunos Matriculados</h6>
                        <p class="small fst-italic">
                          Dados iniciais da turma, geralmente lançadados durante o cadastrado e antes da início da turma. No caso do ensino primário é geralmente lançado depois da realização da aula entrevista.
                        </p>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label text-primary"><strong>Total Alunos MF:</strong></label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @disabled(true) @readonly(true) value="{{ $turma->total_alunos_mf }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label text-primary"><strong>Total Alunos F:</strong></label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @disabled(true) @readonly(true) value="{{ $turma->total_alunos_f }}">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF @if ($turma->subnivei_id >3 ) 17 @else 15 @endif  à 19 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_15_a_19_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F @if ($turma->subnivei_id >3 ) 17 @else 15 @endif à 19 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_15_a_19_anos }}">
                            </div>
                        </div>


                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 20 à 24 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_20_a_24_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 20 à 24 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_20_a_24_anos }}">
                            </div>
                        </div>
                            
                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 25 à 29 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_25_a_29_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 25 à 29 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_25_a_29_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 30 à 34 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_30_a_34_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 30 à 34 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_30_a_34_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 35 à 39 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_35_a_39_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 35 à 39 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_35_a_39_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 40 à 44 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_40_a_44_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 40 à 44 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_40_a_44_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 45 à 49 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_45_a_49_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 45 à 49 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_45_a_49_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 50 à 54 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_50_a_54_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 50 à 54 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_50_a_54_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 55 à 59 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_55_a_59_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 55 à 59 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_55_a_59_anos }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 60 à 64 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_60_a_64_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 60 à 64 anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_60_a_64_anos }}">
                            </div>
                        </div>


                        <div class="row mb-3">
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos MF 65 ou Mais anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_mf_65_ou_mais_anos }}">
                            </div>
                          
                            <label class="col-md-4 col-lg-3 col-form-label">Alunos F 65 ou Mais anos:</label>
                            <div class="col-md-8 col-lg-3">
                                <input class="form-control" @readonly(true) value="{{ $turma->alunos_f_65_ou_mais_anos }}">
                            </div>
                        </div>
                        <!-- End Profile Edit Form -->
      
                    </div>
    
                    <div class="tab-pane fade profile-edit"  id="profile-edit">
                      <!-- Multi Columns Form -->
                      <h6 class="card-title">Dados da Turma</h6>
                      <form class="row g-3" method="POST" enctype="multipart/form-data" id="upload" action="{{route('turma.edit',['valor'=>$turma->id, 'ok'=>1])}}">
                        <input type="hidden" name="metodo" value="dados1">   
                        <div class="col-md-4">
                            <label for="municipio" class="form-label">Província - Município*</label>
                            <select class="form-control" required name="municipio" id="municipio">
                                @forelse ($municipios as $item)
                                  <option @if ($turma->municipio_id == $item->id) @selected(true) @else @endif value="{{$item->id}}">{{$item->nome_province}} - {{$item->nome_municipio}}</option>
                                @empty

                                @endforelse
                            </select>
                            @error('municipio') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                  {{ $message }}
                                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>
                        <div class="col-md-4">
                          <label for="parceiro" class="form-label">Parceiros*</label>
                          <select class="form-control" required name="parceiro" id="parceiro">
                              @forelse ($parceiros as $item)
                                  <option  @if ($turma->parceiro_id == $item->id) @selected(true) @else @endif value="{{$item->id}}">( {{$item->nome_province}} - {{$item->nome_municipio}} ) - {{$item->nome}}</option>
                              @empty
                              
                              @endforelse
                              
                          </select>
                          @error('parceiro') 
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                  {{ $message }}
                                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                          @enderror
                        </div>

                      
                        <div class="col-md-4">
                          <label for="escola" class="form-label">Escolas*</label>
                          <select class="form-control" required name="escola" id="escola">
                              @forelse ($escolas as $item)
                                  <option  @if ($turma->escola_id == $item->id) @selected(true) @else @endif value="{{$item->id}}">( {{$item->nome_province}} - {{$item->nome_municipio}} ) - {{$item->nome}}</option>
                              @empty
                              @endforelse
                              
                          </select>
                          @error('escola') 
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                  {{ $message }}
                                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                          @enderror
                        </div>

                        <div class="col-md-8">
                          <label for="responsavel" class="form-label">Nome do Responsável da Turma (Alfabetizador / Professor)*</label>
                          <input placeholder="Informe o Nome do Responsável da Turma (Alfabetizador / Professor)" class="form-control" max="100" type="text" name="responsavel" id="responsavel" required value="{{ $turma->nome_do_responsavel }}">
                          @error('responsavel')
                            <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                              {{ $message }}
                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                          @enderror
                        </div>

                        <div class="col-md-4">
                          <label for="nascimento" class="form-label">Data de Nascimento*</label>
                          <input placeholder="nascimento" class="form-control" type="date" required name="nascimento" id="nascimento" value="{{ $turma->data_de_nascimento }}">
                          @error('nascimento')
                            <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                              {{ $message }}
                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                          @enderror
                        </div>

                                  <div class="col-md-6">
                                      <label for="morada" class="form-label">Endereço ou Morada do Alfabetizador</label>
                                      <input class="form-control" type="text" placeholder="Informe o Endereço ou Morada do Alfabetizador" required name="morada" id="morada" value="{{ $turma->morada }}">
                                      @error('morada')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-6">
                                      <label for="indentificacao" class="form-label">Nº do Documento de Indentificação (Bilhete ou Passaporte)*</label>
                                      <input placeholder="Informe o Nº do Documento de Indentificação (Bilhete ou Passaporte)" class="form-control" required type="text" name="indentificacao" id="indentificacao" value="{{ $turma->bilhete }}">
                                      @error('indentificacao')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>


                                  

                                  
                                  
                                  

                                  <div class="col-md-6">
                                      <label for="habilitcao" class="form-label">Habilitadção do Responsável da turma*</label>
                                      <select class="form-control" required name="habilitcao" id="habilitcao">
                                          <option  @if ($turma->habilitcao == "MENOS QUE A 6ª CLASSE") @selected(true) @else @endif @disabled(false) value="MENOS QUE A 6ª CLASSE" >MENOS QUE A 6ª CLASSE</option>
                                          <option  @if ($turma->habilitcao == "ENSINO PRIMÁRIO COMPLETO") @selected(true) @else @endif @disabled(false) value="ENSINO PRIMÁRIO COMPLETO" >ENSINO PRIMÁRIO COMPLETO</option>
                                          <option  @if ($turma->habilitcao == "1º CICLO DO ENSINO SECUNDÁRIO") @selected(true) @else @endif @disabled(false) value="1º CICLO DO ENSINO SECUNDÁRIO" >1º CICLO DO ENSINO SECUNDÁRIO</option>
                                          <option  @if ($turma->habilitcao == "2º CICLO DO ENSINO SECUNDÁRIO") @selected(true) @else @endif @disabled(false) value="2º CICLO DO ENSINO SECUNDÁRIO" >2º CICLO DO ENSINO SECUNDÁRIO</option>
                                          <option  @if ($turma->habilitcao == "GRADUAÇÃO COMPLETA (BACHARELADO COMPLETO/ LICENCIATURA COMPLETA)") @selected(true) @else @endif @disabled(false) value="GRADUAÇÃO COMPLETA (BACHARELADO COMPLETO/ LICENCIATURA COMPLETA)" >GRADUAÇÃO COMPLETA (BACHARELADO COMPLETO/ LICENCIATURA COMPLETA)</option>
                                          <option  @if ($turma->habilitcao == "PÓS-GRADUAÇÃO COMPLETA (MESTRADO COMPLETO/ DOUTORAMENTO)") @selected(true) @else @endif @disabled(false) value="PÓS-GRADUAÇÃO COMPLETA (MESTRADO COMPLETO/ DOUTORAMENTO)" >PÓS-GRADUAÇÃO COMPLETA (MESTRADO COMPLETO/ DOUTORAMENTO)</option>
                                          <option  @if ($turma->habilitcao == "NÃO APLICÁVEL") @selected(true) @else @endif @disabled(false) value="NÃO APLICÁVEL" >NÃO APLICÁVEL</option>

                                      </select>
                                      @error('habilitcao') 
                                          <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                              {{ $message }}
                                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                          </div>
                                      @enderror
                                  </div>

                                  
                                  <div class="col-md-6">
                                      <label for="telefone" class="form-label">Telefone*</label>
                                      <input placeholder="Informe o Telefone do Responsável da Turma (Alfabetizador / Professor)" class="form-control" type="tel" name="telefone" id="telefone" required value="{{ $turma->telefone_do_responsavel }}">
                                      @error('telefone')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-6">
                                      <label for="email" class="form-label">Email</label>
                                      <input placeholder="Informe o Email Responsável da Turma (Alfabetizador / Professor)" class="form-control" type="email" name="email" id="email" value="{{ $turma->email_do_responsavel }}">
                                      @error('email')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>


                                  <div class="col-md-3">
                                      <label for="anos" class="form-label">Anos de Experiência*</label>
                                      <input placeholder="Anos como Alfabetizador/Professor" class="form-control" type="number" min="0" max="70" name="anos" id="anos" required value="{{ $turma->anos_como_alfabetizador }}">
                                      @error('anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="ano" class="form-label">Ano última formação</label>
                                      <input placeholder="Ano da última formação" class="form-control" type="number" name="ano" id="ano" value="{{ $turma->ano_da_ultima_formacao }}">
                                      @error('ano')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-6">
                                      <label for="organizador" class="form-label">Organizado por?*</label>
                                      <input placeholder="Informe quem organizou a última formação" class="form-control" type="text" name="organizador" id="organizador" maxlength="200" required value="{{ $turma->organizador }}">
                                      @error('organizador')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="organizador" class="form-label">É funcioná Público?*</label>
                                      <br><span>
                                          <input onchange="ChangAgent();" class="form-check-input" type="radio" name="funcionario_publico" id="funcionario_publico1" value="sim" @if ($turma->funcionario_publico!="não")  @checked(true)  @else @checked(false)  @endif>
                                          <label class="form-check-label" for="funcionario_publico1">
                                          Sim
                                          </label>
                                      </span>
                                      <span>
                                          <input onchange="ChangAgent();" class="form-check-input" type="radio" name="funcionario_publico" id="funcionario_publico2" value="não" @if ($turma->funcionario_publico!="não")  @checked(false)  @else @checked(true)  @endif>
                                          <label class="form-check-label" for="funcionario_publico2">
                                          Não
                                          </label>
                                      </span>
                                  </div>
                                  <div class="col-md-3">
                                      <label for="agente" class="form-label">Número de Agente*</label>
                                      <input class="form-control" type="text" name="agente" id="agente" maxlength="200" required value="{{ $turma->numero_de_agente }}">
                                      @error('agente')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button"  class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <script>
                                      ChangAgent();
                                      function ChangAgent(){
                                          var valor = document.getElementById("funcionario_publico1").checked
                                          if(!valor){
                                              document.getElementById("agente").disabled=true;
                                              document.getElementById("agente").required=false;
                                              
                                          }else{
                                              document.getElementById("agente").disabled=false;
                                              document.getElementById("agente").required=true;
                                          }
                                      }
                                      
                                  </script>



                                  <div class="col-md-6">
                                      <label for="banco" class="form-label">Banco*</label>
                                      <select class="form-control" required name="banco" id="banco">
                                          @forelse ($bancos as $item)
                                              <option @if ($turma->banco_id==$item->id)  @selected(true)  @else @selected(false)  @endif value="{{$item->id}}">{{$item->nome}}</option>
                                          @empty
                                              <option @disabled(true) value="">Nenhum Banco cadastrada</option>
                                          @endforelse
                                      </select>
                                      @error('banco') 
                                          <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                              {{ $message }}
                                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                          </div>
                                      @enderror
                                  </div>


                                  <div class="col-md-6">
                                      <label for="nib" class="form-label">Número Internacional Bancário (IBAN)*</label>
                                      <input class="form-control" type="number" name="nib" id="nib" maxlength="17" required value="{{ $turma->nib }}">
                                      @error('nib')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button"  class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  

                                  <div class="col-md-2">
                                    <label for="anolectivo" class="form-label">Ano lectivo*</label>
                                    <select  class="form-control" required name="anolectivo" id="anolectivo">
                                        @forelse ($anolectivos as $item)
                                            <option @if ($turma->ano_id==$item->id)  @selected(true)  @else @selected(false)  @endif value="{{$item->id}}">{{$item->anolectivo }}</option>
                                        @empty
                                            <option @disabled(true) value="">Nenhum um ano lectivo</option>
                                        @endforelse
                                        
                                    </select>
                                    @error('anolectivo') 
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                            {{ $message }}
                                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    @enderror
                                </div>
                                  
                                  <div class="col-md-4">
                                      <label for="nivel_de_ensino" class="form-label">Nível de Ensino (Módulo ou Ano)*</label>
                                      <select onchange="MudarCiclo();" class="form-control" required name="nivel_de_ensino" id="nivel_de_ensino">
                                          @forelse ($subniveis as $item)
                                              <option @if ($turma->subnivei_id ==$item->id)  @selected(true)  @else @selected(false)  @endif value="{{$item->id}}">{{$item->nivel}} - {{$item->subnivel}}</option>
                                          @empty
                                              <option @disabled(true) value="">Nenhum um Módulo ou Ano</option>
                                          @endforelse
                                          
                                      </select>
                                      @error('nivel_de_ensino') 
                                          <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                              {{ $message }}
                                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                          </div>
                                      @enderror
                                  </div>


                                  <div class="col-md-3">
                                      <label for="turno" class="form-label">Periodo da turma*</label>
                                      <select value="{{ old('turno') }}" class="form-control" required name="turno" id="turno">
                                          @forelse ($turnos as $item)
                                              <option @if ($turma->turno_id ==$item->id)  @selected(true)  @else @selected(false)  @endif  value="{{$item->id}}">{{$item->turno}}</option>
                                          @empty
                                              <option @disabled(true) value="">Nenhum um Periodo</option>
                                          @endforelse
                                          
                                      </select>
                                      @error('turno') 
                                          <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                              {{ $message }}
                                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                          </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="arranque_da_turma" class="form-label">Data de Início da Turma*</label>
                                      <input placeholder="arranque_da_turma" class="form-control" type="date" required name="arranque_da_turma" id="arranque_da_turma" value="{{ $turma->data_de_inicio }}">
                                      @error('arranque_da_turma')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-12">
                                      <label for="referencia" class="form-label">Referência ou Projecto a que a turma pertence*</label>
                                      <select class="form-control" required name="referencia" id="referencia">
                                          @forelse ($projecto_referencias as $item)
                                              <option @if ($turma->referencia_id == $item->id)  @selected(true)  @else @selected(false)  @endif value="{{$item->id}}">{{$item->referencia}}</option>
                                          @empty
                                              <option @disabled(true) value="">Nenhuma Referência (Projecto)</option>
                                          @endforelse
                                          
                                      </select>
                                      @error('referencia') 
                                          <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                              {{ $message }}
                                              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                          </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_mf_15_a_19_anos" class="form-label" id="label_alunos_mf_15_a_19_anos">Alunos MF @if ($turma->subnivei_id >3 ) 17 @else 15 @endif à 19 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_15_a_19_anos','alunos_f_15_a_19_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_15_a_19_anos" id="alunos_mf_15_a_19_anos" value="{{ $turma->alunos_mf_15_a_19_anos }}">
                                      @error('alunos_mf_15_a_19_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_15_a_19_anos" class="form-label" id="label_alunos_f_15_a_19_anos">Alunos F @if ($turma->subnivei_id >3 ) 17 @else 15 @endif à 19 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_15_a_19_anos','alunos_f_15_a_19_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_15_a_19_anos" id="alunos_f_15_a_19_anos" value="{{ $turma->alunos_f_15_a_19_anos  }}">
                                      @error('alunos_f_15_a_19_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>




                                  <div class="col-md-3">
                                      <label for="alunos_mf_20_a_24_anos" class="form-label">Alunos MF 20 à 24 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_20_a_24_anos','alunos_f_20_a_24_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_20_a_24_anos" id="alunos_mf_20_a_24_anos" value="{{ $turma->alunos_mf_20_a_24_anos  }}">
                                      @error('alunos_mf_20_a_24_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_20_a_24_anos" class="form-label">Alunos F 20 à 24 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_20_a_24_anos','alunos_f_20_a_24_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_f_20_a_24_anos" id="alunos_f_20_a_24_anos" value="{{ $turma->alunos_f_20_a_24_anos  }}">
                                      @error('alunos_f_20_a_24_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>




                                  <div class="col-md-3">
                                      <label for="alunos_mf_25_a_29_anos" class="form-label">Alunos MF 25 à 29 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_25_a_29_anos','alunos_f_25_a_29_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_25_a_29_anos" id="alunos_mf_25_a_29_anos" value="{{ $turma->alunos_mf_25_a_29_anos }}">
                                      @error('alunos_mf_25_a_29_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_25_a_29_anos" class="form-label">Alunos F 25 à 29 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_25_a_29_anos','alunos_f_25_a_29_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_25_a_29_anos" id="alunos_f_25_a_29_anos" value="{{ $turma->alunos_f_25_a_29_anos }}">
                                      @error('alunos_f_25_a_29_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>




                                  <div class="col-md-3">
                                      <label for="alunos_mf_30_a_34_anos" class="form-label">Alunos MF 30 à 34 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_30_a_34_anos','alunos_f_30_a_34_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_30_a_34_anos" id="alunos_mf_30_a_34_anos" value="{{ $turma->alunos_mf_30_a_34_anos }}">
                                      @error('alunos_mf_30_a_34_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_30_a_34_anos" class="form-label">Alunos F 30 à 34 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_30_a_34_anos','alunos_f_30_a_34_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_30_a_34_anos" id="alunos_f_30_a_34_anos" value="{{ $turma->alunos_f_30_a_34_anos }}">
                                      @error('alunos_f_30_a_34_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>



                                  <div class="col-md-3">
                                      <label for="alunos_mf_35_a_39_anos" class="form-label">Alunos MF 35 à 39 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_35_a_39_anos','alunos_f_35_a_39_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_35_a_39_anos" id="alunos_mf_35_a_39_anos" value="{{ $turma->alunos_mf_35_a_39_anos }}">
                                      @error('alunos_mf_35_a_39_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_35_a_39_anos" class="form-label">Alunos F 35 à 39 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_35_a_39_anos','alunos_f_35_a_39_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_35_a_39_anos" id="alunos_f_35_a_39_anos" value="{{ $turma->alunos_f_35_a_39_anos }}">
                                      @error('alunos_f_35_a_39_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>




                                  <div class="col-md-3">
                                      <label for="alunos_mf_40_a_44_anos" class="form-label">Alunos MF 40 à 44 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_40_a_44_anos','alunos_f_40_a_44_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_40_a_44_anos" id="alunos_mf_40_a_44_anos" value="{{ $turma->alunos_mf_40_a_44_anos }}">
                                      @error('alunos_mf_40_a_44_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_40_a_44_anos" class="form-label">Alunos F 40 à 44 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_40_a_44_anos','alunos_f_40_a_44_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_40_a_44_anos" id="alunos_f_40_a_44_anos" value="{{ $turma->alunos_f_40_a_44_anos }}">
                                      @error('alunos_f_40_a_44_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>
                                  

                                  <div class="col-md-3">
                                      <label for="alunos_mf_45_a_49_anos" class="form-label">Alunos MF 45 à 49 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_45_a_49_anos','alunos_f_45_a_49_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_45_a_49_anos" id="alunos_mf_45_a_49_anos" value="{{ $turma->alunos_mf_45_a_49_anos }}">
                                      @error('alunos_mf_45_a_49_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_45_a_49_anos" class="form-label">Alunos F 45 à 49 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_45_a_49_anos','alunos_f_45_a_49_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_45_a_49_anos" id="alunos_f_45_a_49_anos" value="{{ $turma->alunos_f_45_a_49_anos }}">
                                      @error('alunos_f_45_a_49_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>



                                  <div class="col-md-3">
                                      <label for="alunos_mf_50_a_54_anos" class="form-label">Alunos MF 50 à 54 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_50_a_54_anos','alunos_f_50_a_54_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_50_a_54_anos" id="alunos_mf_50_a_54_anos" value="{{ $turma->alunos_mf_50_a_54_anos }}">
                                      @error('alunos_mf_50_a_54_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_50_a_54_anos" class="form-label">Alunos F 50 à 54 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_50_a_54_anos','alunos_f_50_a_54_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_50_a_54_anos" id="alunos_f_50_a_54_anos" value="{{ $turma->alunos_f_50_a_54_anos }}">
                                      @error('alunos_f_50_a_54_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>



                                  <div class="col-md-3">
                                      <label for="alunos_mf_55_a_59_anos" class="form-label">Alunos MF 55 à 59 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_55_a_59_anos','alunos_f_55_a_59_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_55_a_59_anos" id="alunos_mf_55_a_59_anos" value="{{ $turma->alunos_mf_55_a_59_anos }}">
                                      @error('alunos_mf_55_a_59_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_55_a_59_anos" class="form-label">Alunos F 55 à 59 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_55_a_59_anos','alunos_f_55_a_59_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_55_a_59_anos" id="alunos_f_55_a_59_anos" value="{{ $turma->alunos_f_55_a_59_anos }}">
                                      @error('alunos_f_55_a_59_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>



                                  <div class="col-md-3">
                                      <label for="alunos_mf_60_a_64_anos" class="form-label">Alunos MF 60 à 64 anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_60_a_64_anos','alunos_f_60_a_64_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_60_a_64_anos" id="alunos_mf_60_a_64_anos" value="{{ $turma->alunos_mf_60_a_64_anos }}">
                                      @error('alunos_mf_60_a_64_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_60_a_64_anos" class="form-label">Alunos F 60 à 64 anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_60_a_64_anos','alunos_f_60_a_64_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_60_a_64_anos" id="alunos_f_60_a_64_anos" value="{{ $turma->alunos_f_60_a_64_anos }}">
                                      @error('alunos_f_60_a_64_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_mf_65_ou_mais_anos" class="form-label">Alunos MF 65 ou Mais anos*</label>
                                      <input onblur="VerifyValue('alunos_mf_65_ou_mais_anos','alunos_f_65_ou_mais_anos');"  class="form-control" type="number" required min="0" max="80" name="alunos_mf_65_ou_mais_anos" id="alunos_mf_65_ou_mais_anos" value="{{ $turma->alunos_mf_65_ou_mais_anos }}">
                                      @error('alunos_mf_65_ou_mais_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>

                                  <div class="col-md-3">
                                      <label for="alunos_f_65_ou_mais_anos" class="form-label">Alunos F 65 ou Mais anos*</label>
                                      <input  onblur="VerifyValue('alunos_mf_65_ou_mais_anos','alunos_f_65_ou_mais_anos');" class="form-control" type="number" required min="0" max="80" name="alunos_f_65_ou_mais_anos" id="alunos_f_65_ou_mais_anos" value="{{ $turma->alunos_f_65_ou_mais_anos }}">
                                      @error('alunos_f_65_ou_mais_anos')
                                        <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                          {{ $message }}
                                          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                      @enderror
                                  </div>


                                  <div class="col-md-3">
                                    <label for="alunos_mf_total_anos" class="form-label">Total Alunos MF</label>
                                    <input class="form-control" type="number" required min="0" max="80" @readonly(true) @disabled(true) id="alunos_mf_total_anos" value="{{ $turma->total_alunos_mf }}">
                                    @error('alunos_mf_total_anos')
                                      <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                      </div>
                                    @enderror
                                </div>

                                <div class="col-md-3">
                                    <label for="alunos_f_total_anos" class="form-label">Total Alunos F</label>
                                    <input class="form-control" type="number" required min="0" max="80" @readonly(true) @disabled(true) id="alunos_f_total_anos" value="{{ $turma->total_alunos_f }}">
                                    @error('alunos_f_total_anos')
                                      <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                      </div>
                                    @enderror
                                </div>


                                
                                  
                                      <input type="hidden" value="{{ $turma->id }}" name="turma">
                                      @method("PUT")
                                      @csrf
                                      <div class="text-center">
                                          <button type="submit" class="btn btn-primary">Salvar</button>
                                          <button type="reset" class="btn btn-secondary">Reset</button>
                                      </div>
                                  </form>
                    </div>
                      
                    <div class="tab-pane fade pt-3" id="documentos">
    
                      <!-- documentos Form BI-->
                      <form class="row g-3" id="documentos_form_bi" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="metodo" value="dados2">
                            <h6 class="card-title">Documento de Identidade</h6>
                            <div class="col-md-6">
                              <label for="foto_id_frontal" class="form-label">Fotografia da Parte frontal (PNG, JPEG, JPG)*</label>
                              <input class="form-control" type="file" required name="foto_id_frontal" id="foto_id_frontal" >
                              @error('foto_id_frontal')
                                  <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                      {{ $message }}
                                      <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                  </div>
                              @enderror
                            </div>
                            <div class="col-md-6">
                                <a href="{{ url("storage/$turma->foto_do_bilhete_frontal")  }}" target="_blank" rel="">
                                    <img id="preview_foto_id_frontal" width="100" height="100" src="{{ url("storage/$turma->foto_do_bilhete_frontal")  }}" alt="" srcset="">
                                </a>
                            </div>

                            <div class="col-md-6">
                                <label for="foto_id_trazeira" class="form-label">Fotografia da Parte Trazeira (PNG, JPEG, JPG)*</label>
                                <input class="form-control"  type="file" required name="foto_id_trazeira" id="foto_id_trazeira" >
                                @error('foto_id_trazeira')
                                    <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                              <a href="{{ url("storage/$turma->foto_do_bilhete_trazeira")  }}" target="_blank" rel="">
                                <img id="preview_foto_id_trazeira" width="100" height="100" src="{{ url("storage/$turma->foto_do_bilhete_trazeira")  }}" alt="" srcset="">
                              </a>
                            </div>
                            <input type="hidden" value="{{ $turma->id }}" name="turma">
                              
                              @csrf
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Salvar</button>
                                <button type="reset" class="btn btn-secondary">Reset</button>
                            </div>
                      </form>
                      <!-- End documentos Form BI-->

                      <!-- documentos Form certificado-->
                      <form class="row g-3" id="documentos_form_certificado" method="POST" enctype="multipart/form-data">
                          <input type="hidden" name="metodo" value="dados3">
                          <h6 class="card-title">Documento de Habilitação</h6>
                            
                            <div class="col-md-6">
                                <label for="foto_da_habilitcao" class="form-label">Fotografia Do Documento (PNG, JPEG, JPG)*</label>
                                <input class="form-control" type="file" required name="foto_da_habilitcao" id="foto_da_habilitcao" >
                                @error('foto_da_habilitcao')
                                    <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                              <a href="{{ url("storage/$turma->foto_da_habilitcao")  }}" target="_blank" rel="">
                                  <img id="preview_foto_da_habilitcao" width="100" height="100" src="{{ url("storage/$turma->foto_da_habilitcao")  }}" alt="" srcset="">
                              </a>
                            </div>
                            
                            <input type="hidden" value="{{ $turma->id }}" name="turma">
                            
                            @csrf
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Salvar</button>
                                <button type="reset" class="btn btn-secondary">Reset</button>
                            </div>
                      </form>
                      <!-- End documentos Form certificado-->



                      <!-- documentos Form bancario-->
                      <form class="row g-3" id="documentos_form_bancario" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="metodo" value="dados4">
                            <h6 class="card-title">Comprovativo bancário</h6>
                          
                            <div class="col-md-6">
                                <label for="comprovativo" class="form-label">Comprovativo Bancário (PNG, JPEG, JPG)*</label>
                                <input class="form-control" type="file" required name="comprovativo" id="comprovativo" >
                                @error('comprovativo')
                                    <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <a href="{{ url("storage/$turma->comprovativo")  }}" target="_blank" rel="">
                                  <img id="preview_comprovativo" width="100" height="100" src="{{ url("storage/$turma->comprovativo")  }}" alt="" srcset="">
                                </a>
                            </div>
                          
                            <input type="hidden" value="{{ $turma->id }}" name="turma">
                            
                            @csrf
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Salvar</button>
                                <button type="reset" class="btn btn-secondary">Reset</button>
                            </div>
                      </form>
                      <!-- End documentos Form bancario-->
    
                    </div>
    
                    <div class="tab-pane fade pt-3" id="foto-da-lista">
                      <!-- foto-da-lista Form -->
                      <form class="row g-3" id="documentos_foto-da-lista" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="metodo" value="dados5">
                            <div class="col-md-6">
                                <label for="lista" class="form-label">Fotografia da lista dos Alunos (PNG, JPEG, JPG)</label>
                                <input class="form-control" type="file" name="lista" id="lista" >
                                @error('lista')
                                    <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                        {{ $message }}
                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <a href="{{ url("storage/$turma->foto_da_lista")  }}" target="_blank" rel="">
                                    <img id="preview_foto_da_lista" width="100" height="100" src="{{ url("storage/$turma->foto_da_lista")  }}" alt="" srcset="">
                                </a>
                            </div>

                            <input type="hidden" value="{{ $turma->id }}" name="turma">
                            
                            @csrf
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Salvar</button>
                                <button type="reset" class="btn btn-secondary">Reset</button>
                            </div>
                        
                      </form>
                      <!-- End foto-da-lista Form -->
    
                    </div>
                    <div class="tab-pane fade pt-3" id="detalhe_aproveitamento">
                        <h6 class="card-title">Aproveitamento da Turma</h6>
                        <p class="small fst-italic">
                          Dados finais da turma, geralmente lançadados após a avaliação final dos alunos da turma.
                        </p>
                          <div class="row mb-3">
                              <!-- Graf Aproveitamento MF -->
                              <div class="col-md-3 col-lg-6">
                                <div class="card">
                                  <div class="card-body">
                                    <h5 class="card-title">Aproveitamento (Alunos MF)</h5>
                      
                                    <!-- Bar Chart -->
                                    <div id="aproveitamento_mf"></div>
                      
                                    <script>
                                        document.addEventListener("DOMContentLoaded", () => {
                                          new ApexCharts(document.querySelector("#aproveitamento_mf"), {
                                            series: [{
                                              data: [{{ $aproveitamento->total_matriculados_mf }}, {{ $aproveitamento->total_aprovados_mf }}, {{ $aproveitamento->total_reprovados_mf }}, {{ $aproveitamento->total_desistentes_mf }}]
                                              
                                            }],
                                            chart: {
                                              type: 'bar',
                                              height: 350
                                            },
                                            plotOptions: {
                                              bar: {
                                                borderRadius: 4,
                                                horizontal: false,
                                              }
                                            },
                                            dataLabels: {
                                              enabled: true
                                            },
                                            colors: ['red'],
                                            colors: ['gray'],
                                            xaxis: {
                                              categories: ['Matriculados MF','Aprovados MF', 'Reprovados MF', 'Desistentes MF'],
                                            }
                                          }).render();
                                        });
                                      </script>
                                      <!-- End Bar Chart -->
                        
                                    </div>
                                  </div>
                              </div>
                              <!-- End Graf Aproveitamento MF -->

                              <!-- Graf % Aproveitamento MF-->
                              <div class="col-md-3 col-lg-6">
                                <div class="card">
                                  <div class="card-body">
                                    <h6 class="card-title">% Aproveitamento (Alunos MF)</h6>
                                    <!-- Pie Chart -->
                                    <div id="aproveitamento_percentual_mf"></div>
                      
                                    <script>
                                          document.addEventListener("DOMContentLoaded", () => {
                                          // alert({{ $aproveitamento->total_aprovados_f }}, {{ $aproveitamento->total_aprovados_mf }})
                                            new ApexCharts(document.querySelector("#aproveitamento_percentual_mf"), {
                                              series: [{{ $aproveitamento->total_aprovados_mf }}, {{ $aproveitamento->total_reprovados_mf }}, {{ $aproveitamento->total_desistentes_mf }}],
                                              chart: {
                                                height: 350,
                                                type: 'pie',
                                                toolbar: {
                                                  show: true
                                                }
                                              },
                                              colors: ['green','orange','red'],
                                              labels: ['Aprovados MF', 'Reprovados MF', 'Desistentes MF']
                                            }).render();
                                          });
                                    </script>
                                    <!-- End Pie Chart -->
                      
                                  </div>
                                </div>
                              </div>
                              <!-- End % Graf Aproveitamento MF-->
                          </div>
                          <div class="row mb-3">
                              <!-- Graf Aproveitamento F -->
                              <div class="col-md-3 col-lg-6">
                                <div class="card">
                                  <div class="card-body">
                                    <h5 class="card-title">Aproveitamento (Alunos F)</h5>
                      
                                    <!-- Bar Chart -->
                                    <div id="aproveitamento_f"></div>
                      
                                    <script>
                                        document.addEventListener("DOMContentLoaded", () => {
                                          new ApexCharts(document.querySelector("#aproveitamento_f"), {
                                            series: [{
                                              data: [{{ $aproveitamento->total_matriculados_f }}, {{ $aproveitamento->total_aprovados_f }}, {{ $aproveitamento->total_reprovados_f }}, {{ $aproveitamento->total_desistentes_f }}]
                                            }],
                                            chart: {
                                              type: 'bar',
                                              height: 350,
                                            },
                                            plotOptions: {
                                              bar: {
                                                borderRadius: 4,
                                                horizontal: false,
                                              }
                                            },
                                            dataLabels: {
                                              enabled: true
                                            },
                                          // colors: ['red'],
                                            colors: ['gray'],
                                            xaxis: {
                                              size: 10,
                                              categories: ['Matriculados F','Aprovados F', 'Reprovados F', 'Desistentes F'],
                                            }
                                          }).render();
                                        });
                                      </script>
                                      <!-- End Bar Chart -->
                        
                                    </div>
                                  </div>
                              </div>
                              <!-- End Graf Aproveitamento F -->

                              <!-- Graf % Aproveitamento F-->
                              <div class="col-md-3 col-lg-6">
                                <div class="card">
                                  <div class="card-body">
                                    <h6 class="card-title">% Aproveitamento (Alunos F)</h6>
                                    <!-- Pie Chart -->
                                    <div id="aproveitamento_percentual_f"></div>
                      
                                    <script>
                                          document.addEventListener("DOMContentLoaded", () => {
                                          // alert({{ $aproveitamento->total_aprovados_f }}, {{ $aproveitamento->total_aprovados_mf }})
                                            new ApexCharts(document.querySelector("#aproveitamento_percentual_f"), {
                                              series: [{{ $aproveitamento->total_aprovados_f }}, {{ $aproveitamento->total_reprovados_f }}, {{ $aproveitamento->total_desistentes_f }}],
                                              chart: {
                                                height: 350,
                                                type: 'pie',
                                                toolbar: {
                                                  show: true
                                                }
                                              },
                                              colors: ['green','orange','red'],
                                              labels: ['Aprovados F', 'Reprovados F', 'Desistentes F']
                                            }).render();
                                          });
                                    </script>
                                    <!-- End Pie Chart -->
                      
                                  </div>
                                </div>
                              </div>
                              <!-- End % Graf Aproveitamento F-->
                          </div>
                          <div class="row mb-3">
                              <!-- Matricula por intervalo de idade MF -->
                              <div class="col-lg-12">
                                <div class="card">
                                  <div class="card-body">
                                    <h5 class="card-title">Aproveitamento por Intervalos de Idade (MF)</h5>
                      
                                    <!-- Column Chart -->
                                    <div id="columnChart"></div>
                      
                                    <script>
                                      document.addEventListener("DOMContentLoaded", () => {
                                        new ApexCharts(document.querySelector("#columnChart"), {
                                          series: [{
                                            name: 'Matriculados',
                                            data: [{{$aproveitamento->matriculados_mf_15_a_19_anos}}, {{$aproveitamento->matriculados_mf_20_a_24_anos}}, {{$aproveitamento->matriculados_mf_25_a_29_anos}} , {{$aproveitamento->matriculados_mf_30_a_34_anos}}, {{$aproveitamento->matriculados_mf_35_a_39_anos}}, {{$aproveitamento->matriculados_mf_40_a_44_anos}},{{$aproveitamento->matriculados_mf_45_a_49_anos}}, {{$aproveitamento->matriculados_mf_50_a_54_anos}}, {{$aproveitamento->matriculados_mf_55_a_59_anos}},{{$aproveitamento->matriculados_mf_60_a_64_anos}}, {{$aproveitamento->matriculados_mf_65_ou_mais_anos}}]
                                          }, {
                                            name: 'Aprovados',
                                            data: [{{$aproveitamento->aprovados_mf_15_a_19_anos}}, {{$aproveitamento->aprovados_mf_20_a_24_anos}}, {{$aproveitamento->aprovados_mf_25_a_29_anos}} , {{$aproveitamento->aprovados_mf_30_a_34_anos}}, {{$aproveitamento->aprovados_mf_35_a_39_anos}}, {{$aproveitamento->aprovados_mf_40_a_44_anos}},{{$aproveitamento->aprovados_mf_45_a_49_anos}}, {{$aproveitamento->aprovados_mf_50_a_54_anos}}, {{$aproveitamento->aprovados_mf_55_a_59_anos}},{{$aproveitamento->aprovados_mf_60_a_64_anos}}, {{$aproveitamento->aprovados_mf_65_ou_mais_anos}}]
                                          }, {
                                            name: 'Reprovados',
                                            data: [{{$aproveitamento->reprovados_mf_15_a_19_anos}}, {{$aproveitamento->reprovados_mf_20_a_24_anos}}, {{$aproveitamento->reprovados_mf_25_a_29_anos}} , {{$aproveitamento->reprovados_mf_30_a_34_anos}}, {{$aproveitamento->reprovados_mf_35_a_39_anos}}, {{$aproveitamento->reprovados_mf_40_a_44_anos}},{{$aproveitamento->reprovados_mf_45_a_49_anos}}, {{$aproveitamento->reprovados_mf_50_a_54_anos}}, {{$aproveitamento->reprovados_mf_55_a_59_anos}},{{$aproveitamento->reprovados_mf_60_a_64_anos}}, {{$aproveitamento->reprovados_mf_65_ou_mais_anos}}]
                                          },
                                          {
                                            name: 'Desistentes',
                                            data: [{{$aproveitamento->desistentes_mf_15_a_19_anos}}, {{$aproveitamento->desistentes_mf_20_a_24_anos}}, {{$aproveitamento->desistentes_mf_25_a_29_anos}} , {{$aproveitamento->desistentes_mf_30_a_34_anos}}, {{$aproveitamento->desistentes_mf_35_a_39_anos}}, {{$aproveitamento->desistentes_mf_40_a_44_anos}},{{$aproveitamento->desistentes_mf_45_a_49_anos}}, {{$aproveitamento->desistentes_mf_50_a_54_anos}}, {{$aproveitamento->desistentes_mf_55_a_59_anos}},{{$aproveitamento->desistentes_mf_60_a_64_anos}}, {{$aproveitamento->desistentes_mf_65_ou_mais_anos}}]
                                          }
                                        ],
                                          chart: {
                                            type: 'bar',
                                            height: 350
                                          },
                                          plotOptions: {
                                            bar: {
                                              horizontal: false,
                                              columnWidth: '90%',
                                              endingShape: 'rounded',
                                            },
                                          },
                                          dataLabels: {
                                            enabled: true
                                          },
                                          stroke: {
                                            show: true,
                                            width: 4,
                                            colors: ['transparent']
                                          },
                                          xaxis: {
                                            categories: [ @if ($turma->subnivei_id >3 ) "17 à 19 MF" @else "15 à 19 MF" @endif, "20 à 24 MF", "25 à 29 MF" ,"30 à 34 MF", "35 à 39 MF", "40 à 44 MF", "45 à 49 MF",  "50 à 54 MF", "55 à 59 MF", "60 à 64 MF","65 ou Mais"],
                                          },
                                          yaxis: {
                                            title: {
                                              text: 'Valores'
                                            }
                                          },
                                          fill: {
                                            opacity: 4
                                          },
                                          tooltip: {
                                            y: {
                                              formatter: function(val) {
                                                return val
                                              }
                                            }
                                          }
                                        }).render();
                                      });
                                    </script>
                                    <!-- End Column Chart -->
                      
                                  </div>
                                </div>
                              </div>
                              <!-- Matricula por intervalo de idade MF-->
                          </div>

                          <div class="row mb-3">
                              <!-- Matricula por intervalo de idade F -->
                              <div class="col-lg-12">
                                <div class="card">
                                  <div class="card-body">
                                    <h5 class="card-title">Aproveitamento por Intervalos de Idade (F)</h5>
                      
                                    <!-- Column Chart -->
                                    <div id="columnChart_f"></div>
                      
                                    <script>
                                      document.addEventListener("DOMContentLoaded", () => {
                                        new ApexCharts(document.querySelector("#columnChart_f"), {
                                          series: [{
                                            name: 'Matriculados: ',
                                            data: [{{$aproveitamento->matriculados_f_15_a_19_anos}}, {{$aproveitamento->matriculados_f_20_a_24_anos}}, {{$aproveitamento->matriculados_f_25_a_29_anos}} , {{$aproveitamento->matriculados_f_30_a_34_anos}}, {{$aproveitamento->matriculados_f_35_a_39_anos}}, {{$aproveitamento->matriculados_f_40_a_44_anos}},{{$aproveitamento->matriculados_f_45_a_49_anos}}, {{$aproveitamento->matriculados_f_50_a_54_anos}}, {{$aproveitamento->matriculados_f_55_a_59_anos}},{{$aproveitamento->matriculados_f_60_a_64_anos}}, {{$aproveitamento->matriculados_f_65_ou_mais_anos}}]
                                          }, {
                                            name: 'Aprovados',
                                            data: [{{$aproveitamento->aprovados_f_15_a_19_anos}}, {{$aproveitamento->aprovados_f_20_a_24_anos}}, {{$aproveitamento->aprovados_f_25_a_29_anos}} , {{$aproveitamento->aprovados_f_30_a_34_anos}}, {{$aproveitamento->aprovados_f_35_a_39_anos}}, {{$aproveitamento->aprovados_f_40_a_44_anos}},{{$aproveitamento->aprovados_f_45_a_49_anos}}, {{$aproveitamento->aprovados_f_50_a_54_anos}}, {{$aproveitamento->aprovados_f_55_a_59_anos}},{{$aproveitamento->aprovados_f_60_a_64_anos}}, {{$aproveitamento->aprovados_f_65_ou_mais_anos}}]
                                          }, {
                                            name: 'Reprovados',
                                            data: [{{$aproveitamento->reprovados_f_15_a_19_anos}}, {{$aproveitamento->reprovados_f_20_a_24_anos}}, {{$aproveitamento->reprovados_f_25_a_29_anos}} , {{$aproveitamento->reprovados_f_30_a_34_anos}}, {{$aproveitamento->reprovados_f_35_a_39_anos}}, {{$aproveitamento->reprovados_f_40_a_44_anos}},{{$aproveitamento->reprovados_f_45_a_49_anos}}, {{$aproveitamento->reprovados_f_50_a_54_anos}}, {{$aproveitamento->reprovados_f_55_a_59_anos}},{{$aproveitamento->reprovados_f_60_a_64_anos}}, {{$aproveitamento->reprovados_f_65_ou_mais_anos}}]
                                          },
                                          {
                                            name: 'Desistentes',
                                            data: [{{$aproveitamento->desistentes_f_15_a_19_anos}}, {{$aproveitamento->desistentes_f_20_a_24_anos}}, {{$aproveitamento->desistentes_f_25_a_29_anos}} , {{$aproveitamento->desistentes_f_30_a_34_anos}}, {{$aproveitamento->desistentes_f_35_a_39_anos}}, {{$aproveitamento->desistentes_f_40_a_44_anos}},{{$aproveitamento->desistentes_f_45_a_49_anos}}, {{$aproveitamento->desistentes_f_50_a_54_anos}}, {{$aproveitamento->desistentes_f_55_a_59_anos}},{{$aproveitamento->desistentes_f_60_a_64_anos}}, {{$aproveitamento->desistentes_f_65_ou_mais_anos}}]
                                          }
                                        ],
                                          chart: {
                                            type: 'bar',
                                            height: 350
                                          },
                                          plotOptions: {
                                            bar: {
                                              horizontal: false,
                                              columnWidth: '90%',
                                              endingShape: 'rounded',
                                            },
                                          },
                                          dataLabels: {
                                            enabled: true
                                          },
                                          stroke: {
                                            show: true,
                                            width: 4,
                                            colors: ['transparent']
                                          },
                                          xaxis: {
                                            categories: [ @if ($turma->subnivei_id >3 ) "17 à 19 F" @else "15 à 19 F" @endif, "20 à 24 F", "25 à 29 F" ,"30 à 34 F", "35 à 39 F", "40 à 44 F", "45 à 49 F",  "50 à 54 F", "55 à 59 F", "60 à 64 F","65 ou Mais"],
                                          },
                                          yaxis: {
                                            title: {
                                              text: 'Valores'
                                            }
                                          },
                                          fill: {
                                            opacity: 4
                                          },
                                          tooltip: {
                                            y: {
                                              formatter: function(val) {
                                                return val
                                              }
                                            }
                                          }
                                        }).render();
                                      });
                                    </script>
                                    <!-- End Column Chart -->
                      
                                  </div>
                                </div>
                              </div>
                              <!-- Matricula por intervalo de idade F-->
                          </div>
                          <!-- Aproveitamento Totais-->
                          <div class="row mb-3">
                              <div class="col-lg-12">

                                  <div class="card">
                                      <div class="card-body">
                                        <h5 class="card-title">Aproveitamento da Turma</h5>
                                        <p>Add lightweight datatables to your project with using the <a href="https://github.com/fiduswriter/Simple-DataTables" target="_blank">Simple DataTables</a> library. Just add <code>.datatable</code> class name to any table you wish to conver to a datatable. Check for <a href="https://fiduswriter.github.io/simple-datatables/demos/" target="_blank">more examples</a>.</p>
                          
                                        <!-- Table with stripped rows -->
                                        <table class="table datatable" style="font-size: 10px; text-align: center">
                                            <thead>
                                              <tr>
                                                  <th></th>
                                                  <th>Matriculados MF</th>
                                                  <th>Matriculados F</th>
                                                  <th>Aprovados MF</th>
                                                  <th>Aprovados F</th>
                                                  <th>Reprovados MF</th>
                                                  <th>Reprovados F</th>
                                                  <th>Desistentes MF</th>
                                                  <th>Desistentes F</th>
                                              </tr>
                                            </thead>
                                            <tbody>
                                              <tr>
                                                  <td>
                                                    <b>@if ($turma->subnivei_id >3 )17 à 19 @else 15 à 19 @endif: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_15_a_19_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_15_a_19_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_15_a_19_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_15_a_19_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_15_a_19_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_15_a_19_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_15_a_19_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_15_a_19_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>20 à 24: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_20_a_24_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_20_a_24_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_20_a_24_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_20_a_24_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_20_a_24_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_20_a_24_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_20_a_24_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_20_a_24_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>25 à 29: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_25_a_29_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_25_a_29_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_25_a_29_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_25_a_29_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_25_a_29_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_25_a_29_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_25_a_29_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_25_a_29_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>30 à 34: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_30_a_34_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_30_a_34_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_30_a_34_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_30_a_34_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_30_a_34_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_30_a_34_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_30_a_34_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_30_a_34_anos }}</td>
                                              </tr>
                                              <tr>
                                                  <td>
                                                    <b>35 à 39: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_35_a_39_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_35_a_39_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_35_a_39_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_35_a_39_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_35_a_39_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_35_a_39_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_35_a_39_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_35_a_39_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>40 à 44: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_40_a_44_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_40_a_44_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_40_a_44_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_40_a_44_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_40_a_44_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_40_a_44_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_40_a_44_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_40_a_44_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>45 à 49: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_45_a_49_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_45_a_49_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_45_a_49_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_45_a_49_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_45_a_49_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_45_a_49_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_45_a_49_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_45_a_49_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>50 à 54: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_50_a_54_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_50_a_54_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_50_a_54_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_50_a_54_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_50_a_54_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_50_a_54_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_50_a_54_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_50_a_54_anos }}</td>
                                              </tr>


                                              <tr>
                                                  <td>
                                                    <b>55 à 59: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_55_a_59_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_55_a_59_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_55_a_59_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_55_a_59_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_55_a_59_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_55_a_59_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_55_a_59_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_55_a_59_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>60 à 64: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_60_a_64_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_60_a_64_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_60_a_64_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_60_a_64_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_60_a_64_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_60_a_64_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_60_a_64_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_60_a_64_anos }}</td>
                                              </tr>

                                              <tr>
                                                  <td>
                                                    <b>65 ou Mais: </b>
                                                  </td>
                                                  <td>{{ $aproveitamento->matriculados_mf_65_ou_mais_anos}}</td>
                                                  <td>{{ $aproveitamento->matriculados_f_65_ou_mais_anos}}</td>
                                                  <td>{{ $aproveitamento->aprovados_mf_65_ou_mais_anos }}</td>
                                                  <td>{{ $aproveitamento->aprovados_f_65_ou_mais_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_mf_65_ou_mais_anos }}</td>
                                                  <td>{{ $aproveitamento->reprovados_f_65_ou_mais_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_mf_65_ou_mais_anos }}</td>
                                                  <td>{{ $aproveitamento->desistentes_f_65_ou_mais_anos }}</td>
                                              </tr>
                                              
                                            </tbody>
                                            <tfoot>
                                                  <tr>
                                                      <th><b>Total geral: </b></th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_matriculados_mf}}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_matriculados_f}}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_aprovados_mf }}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_aprovados_f }}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_reprovados_mf }}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_reprovados_f }}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_desistentes_mf }}</th>
                                                      <th style="text-align: center">{{ $aproveitamento->total_desistentes_f }}</th>
                                                  </tr>
                                            </tfoot>
                                        </table>
                                        <!-- End Table with stripped rows -->
                          
                                      </div>
                                  </div>
                      
                              </div>
                          </div>
                          <!-- END Aproveitamento Totais-->
                          <!-- Aproveitamento por idade-->
                          <div class="row mb-3">
                           </div>
                          <!-- END Aproveitamento por idade-->
                      </div>
                </div>
                <!-- End Bordered Tabs -->
  
              </div>
            </div>
  
          </div>
        </div>
      </section>
  

  </main>
  <!-- End #main -->


  <script>
        
        var ciclo =  document.getElementById('nivel_de_ensino');
        var label_mf =  document.getElementById('label_alunos_mf_15_a_19_anos');
        var label_f =  document.getElementById('label_alunos_f_15_a_19_anos');
        // 
        function MudarCiclo(){
            if(ciclo.value>3){
                label_mf.innerHTML = "Alunos MF 17 à 19 anos*";
                label_f.innerHTML = "Alunos F 17 à 19 anos*";
            }else{
                label_mf.innerHTML = "Alunos MF 15 à 19 anos*";
                label_f.innerHTML = "Alunos F 15 à 19 anos*";
            }
        }
        
        function VerifyValue(idMF,idF){
            var valorMf = document.getElementById(idMF);
            var valorF = document.getElementById(idF);
            if(Number(valorMf.value)<Number(valorF.value)){
                valorMf.style.borderBlockColor="red";
                valorF.style.borderBlockColor="red";
                //alert("O valor de "+idMF+" deve ser superior a "+idF+". ");
            }else{
                valorMf.style.borderBlockColor="";
                valorF.style.borderBlockColor="";
            }
            Calc_total();   
        }

        var alunos_mf_15_a_19_anos = document.getElementById('alunos_mf_15_a_19_anos');
        var alunos_mf_20_a_24_anos = document.getElementById('alunos_mf_20_a_24_anos');
        var alunos_mf_25_a_29_anos = document.getElementById('alunos_mf_25_a_29_anos');
        var alunos_mf_30_a_34_anos = document.getElementById('alunos_mf_30_a_34_anos');
        var alunos_mf_35_a_39_anos = document.getElementById('alunos_mf_35_a_39_anos');
        var alunos_mf_40_a_44_anos = document.getElementById('alunos_mf_40_a_44_anos');
        var alunos_mf_45_a_49_anos = document.getElementById('alunos_mf_45_a_49_anos');
        var alunos_mf_50_a_54_anos = document.getElementById('alunos_mf_50_a_54_anos');
        var alunos_mf_55_a_59_anos = document.getElementById('alunos_mf_55_a_59_anos');
        var alunos_mf_60_a_64_anos = document.getElementById('alunos_mf_60_a_64_anos');
        var alunos_mf_65_ou_mais_anos = document.getElementById('alunos_mf_65_ou_mais_anos');

        var alunos_f_15_a_19_anos = document.getElementById('alunos_f_15_a_19_anos');
        var alunos_f_20_a_24_anos = document.getElementById('alunos_f_20_a_24_anos');
        var alunos_f_25_a_29_anos = document.getElementById('alunos_f_25_a_29_anos');
        var alunos_f_30_a_34_anos = document.getElementById('alunos_f_30_a_34_anos');
        var alunos_f_35_a_39_anos = document.getElementById('alunos_f_35_a_39_anos');
        var alunos_f_40_a_44_anos = document.getElementById('alunos_f_40_a_44_anos');
        var alunos_f_45_a_49_anos = document.getElementById('alunos_f_45_a_49_anos');
        var alunos_f_50_a_54_anos = document.getElementById('alunos_f_50_a_54_anos');
        var alunos_f_55_a_59_anos = document.getElementById('alunos_f_55_a_59_anos');
        var alunos_f_60_a_64_anos = document.getElementById('alunos_f_60_a_64_anos');
        var alunos_f_65_ou_mais_anos = document.getElementById('alunos_f_65_ou_mais_anos');
        
        
        Calc_total();

        
        function Calc_total(){
                document.getElementById('alunos_mf_total_anos').value = 
                              (alunos_mf_15_a_19_anos.value*1+  
                              alunos_mf_20_a_24_anos.value*1+alunos_mf_25_a_29_anos.value*1+ 
                              alunos_mf_30_a_34_anos.value*1+alunos_mf_35_a_39_anos.value*1+ 
                              alunos_mf_40_a_44_anos.value*1+alunos_mf_45_a_49_anos.value*1+ 
                              alunos_mf_50_a_54_anos.value*1+alunos_mf_55_a_59_anos.value*1+ 
                              alunos_mf_60_a_64_anos.value*1+alunos_mf_65_ou_mais_anos.value*1);
                      
                document.getElementById('alunos_f_total_anos').value = 
                            (alunos_f_15_a_19_anos.value*1+  
                              alunos_f_20_a_24_anos.value*1+alunos_f_25_a_29_anos.value*1+ 
                              alunos_f_30_a_34_anos.value*1+alunos_f_35_a_39_anos.value*1+ 
                              alunos_f_40_a_44_anos.value*1+alunos_f_45_a_49_anos.value*1+ 
                              alunos_f_50_a_54_anos.value*1+alunos_f_55_a_59_anos.value*1+ 
                              alunos_f_60_a_64_anos.value*1+alunos_f_65_ou_mais_anos.value*1);
        }
  </script>

@endsection