@extends('layouts.navigation')
@section('content')
<?php 
  $counter=0; 
  $counter_com_pauta=0;
  $counter_com_pauta_percent=0;
  $tota_alunos_MF=0;
  $tota_alunos_F=0;
  $tota_alunos_F_percent=0;

 
?>
  <main id="main" class="main">
    
    <!-- Page Title -->
    <div class="pagetitle">
      <h1>Turmas</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{ route('turma.index') }}">Turmas</a></li>
          <li class="breadcrumb-item active">Dados de Cadastro</li>
        </ol>
      </nav>
    </div>
    <!-- End Page Title -->
    <section class="section">
      <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                  <div class="card-body text-center">
                    <h6 class="card-title">Turmas cadastradas </h6>
                    <h4 id="cadastradas">
                        {{ $counter }}
                    </h4>
                    <div class="progress mt-1">
                        <div class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">100%</div>
                    </div>
                  </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
              <div class="card">
                <div class="card-body text-center">
                  <h6 class="card-title">Turmas com pauta </h6>
                  <h4 id="compauta">
                    {{ $counter_com_pauta }}
                  </h4>
                  <div class="progress mt-1">
                    <div id="progree_compauta" class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar" style="width: 0%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>
                </div>
              </div>
          </div>

          <div class="col-lg-3 col-sm-6">
            <div class="card">
              <div class="card-body text-center">
                <h6 class="card-title">Alunos MF </h6>
                <h4 id="alunosmf">
                  {{ $tota_alunos_MF }}
                </h4>
                <div class="progress mt-1">
                  <div class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">100%</div>
                </div>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-sm-6">
            <div class="card">
              <div class="card-body text-center">
                <h6 class="card-title">Alunos F </h6>
                <h4 id="alunosf">
                  {{ $tota_alunos_MF }}
                </h4>
                <div class="progress mt-1">
                  <div id="progress_fem" class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
            </div>
          </div>
      </div>
    <section>
    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Dados iniciais das turmas</h5>
              <div class="row">
                  <div class="col-lg-8">
                      @if (session('status'))
                          <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="bi bi-check-circle me-1"></i>
                            {{ session('status') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                          </div>
                      @endif
                  </div>
                  <div class="col-lg-4" style="text-align: right; padding-right: 2%">
                    @if (1)
                        <a href="{{route('turma.create')}}" data-bs-toggle="tooltip" data-bs-placement="top" title="Cadastrar uma nova turma." class="btn btn-dark"><i class="bi bi-folder-plus"></i></a>
                    @endif
                  </div>
              </div>


              <!-- Table with stripped rows -->
              <table class="table datatable responsive" >
                <thead>
                  <tr style="font-size: 10px">
                    <th>Província</th>
                    <th>Município</th>
                    <th>Aproveitamento</th>
                    <th>Responsável</th>
                    <th title="Nível de ensino">Nível</th>
                    <th title="Ano lectivo">Ano</th>
                    <th title="Total de alunos MF matriculados na turma inicialmente.">MF</th>
                    <th title="Total de alunos F matriculados na turma inicialmente.">F</th>
                    <th colspan="4">Acção</th>
                  </tr>
                </thead>
                <tbody>
                    
                    @foreach ($Alfabetizadoresturmas as $Item)
                    <?php
                        $counter++; 
                        $tota_alunos_MF +=$Item->total_alunos_mf;
                        $tota_alunos_F +=$Item->total_alunos_f;
                    ?>
                    <tr>
                      <td class="" style="font-size: 10px">{{$Item->nome_provincia}}</td>
                      <td class="" style="font-size: 10px">{{$Item->nome_municipio}}</td> 
                      <td>
                        <!--show_aproveitamento -->
                            @if ($Item->idAproveitamento!=null)
                            <?php $counter_com_pauta++; ?>
                              <a href="{{route('turma.create', ['valor'=>$Item->idAproveitamento, 'ok'=>1]) }}" data-bs-toggle="tooltip" data-bs-placement="top" title="Ver os dados finais (pauta) da turma.">
                                <span class="badge bg-success"><i class="bi bi-card-checklist me-1"></i> Ver a pauta</span>
                              </a>
                            @else
                              <span class="badge bg-warning text-dark"><i class="bi bi-card-checklist me-1"></i> Sem a pauta</span>
                            @endif
                      </td>
                        <td class="" style="font-size: 10px">{{$Item->nome_do_responsavel}}</td>
                        <td class="" style="font-size: 10px">{{$Item->nivel}} <br> {{$Item->subnivel}}</td>
                        <td class="" style="font-size: 10px">{{$Item->anolectivo}}</td>

                        <td class="" style="font-size: 10px">{{$Item->total_alunos_mf}}</td>
                        <td class="" style="font-size: 10px">{{$Item->total_alunos_f}}</td>
                        
                        <td style="width: 22%;">
                          @if (($user->role_id=='1' or $user->role_id=='2') or ($user->id == $Item->user_id))
                              <a href="{{route('turma.edit', ['valor'=>$Item->id, 'ok'=>1]) }}" data-bs-toggle="tooltip" data-bs-placement="top" title="Alterar os dados da turma." type="button" class="btn btn-sm btn-primary"><i class="bi bi-pencil"></i></a>
                          @endif
                          @if (($user->role_id=='1' or $user->role_id=='2'))
                                <form style="display: inline-block;" action="{{route('turma.destroy', ['ok'=>1])}}" method="post">
                                    <input type="hidden" name="turma" value="{{$Item->id}}">
                                    @csrf
                                    @method('DELETE')
                                    <button data-bs-toggle="tooltip" data-bs-placement="top" title="Deletar permanentemente os dados desta turma." type="submit" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                                </form>
                            @endif
                        </td> 
                        
                         
                    </tr> 

                    @endforeach
                </tbody>
              </table>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
<?php
    if ($tota_alunos_MF>0) {
        $tota_alunos_F_percent = 100*($tota_alunos_F/$tota_alunos_MF);
    }

    if ($counter>0) {
        $counter_com_pauta_percent = 100*($counter_com_pauta/$counter);
    }

?>
<script>
      document.getElementById("cadastradas").innerHTML =  {{ $counter }}
      document.getElementById("compauta").innerHTML =  {{ $counter_com_pauta }}
      document.getElementById("alunosmf").innerHTML =  {{ $tota_alunos_MF }}
      document.getElementById("alunosf").innerHTML =  {{ $tota_alunos_F }}

      var progree_compauta_valor = Math.round({{ $counter_com_pauta_percent }})+"%";
      var progree_compauta = document.getElementById("progree_compauta");
      progree_compauta.style.width = progree_compauta_valor;
      progree_compauta.innerHTML = progree_compauta_valor;
      
      var progress_fem_valor = Math.round({{ $tota_alunos_F_percent }})+"%";
      var progress_fem = document.getElementById("progress_fem");
      progress_fem.style.width = progress_fem_valor;
      progress_fem.innerHTML = progress_fem_valor;   
</script>
@endsection