<?php

use App\Http\Controllers\AlfabetizadoresturmasController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EntidadeController;
use App\Http\Controllers\EscolaController;
use App\Http\Controllers\MunicipioController;
use App\Http\Controllers\NiveiController;
use App\Http\Controllers\ParceiroController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProvinceController;
use App\Http\Controllers\RegistoController;
use App\Http\Controllers\SubniveiController;
use App\Http\Controllers\UserController;

use Illuminate\Support\Facades\Route;


    Route::get('/', function () {
        return view('welcome');
    });
    /*
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->middleware(['auth', 'verified'])->name('dashboard');
    */
    Route::get('/dashboard',[DashboardController::class, 'index'] )->middleware(['auth', 'verified'])->name('dashboard');
    Route::middleware('auth')
    ->group(function () {
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    });

    


  
   require __DIR__.'/auth.php';

    
// Entidades
Route::get('/entidade', [EntidadeController::class, 'index'])->middleware(['auth', 'verified'])->name('entidade.index');
Route::get('/entidade/{valor}/show', [EntidadeController::class, 'show'])->middleware(['auth', 'verified'])->name('entidade.show'); 
Route::get('/entidade/{valor}/edit', [EntidadeController::class, 'edit'])->middleware(['auth', 'verified'])->name('entidade.edit');
Route::put('/entidade/{valor}/edit', [EntidadeController::class, 'update'])->middleware(['auth', 'verified'])->name('entidade.edit');
Route::delete('/entidade/destroy', [EntidadeController::class, 'destroy'])->middleware(['auth', 'verified'])->name('entidade.destroy');
// Entidades

// Users
Route::get('/utilizador', [UserController::class, 'index'])->middleware(['auth', 'verified'])->name('utilizador.index');
Route::get('/utilizador/{valor}/show', [UserController::class, 'show'])->middleware(['auth', 'verified'])->name('utilizador.show'); 
Route::get('/utilizador/create', [UserController::class, 'create'])->middleware(['auth', 'verified'])->name('utilizador.create');
Route::post('/utilizador/create', [UserController::class, 'store'])->middleware(['auth', 'verified'])->name('utilizador.create');
Route::delete('/utilizador/destroy', [UserController::class, 'destroy'])->middleware(['auth', 'verified'])->name('utilizador.destroy');
Route::post('/utilizador/activate', [UserController::class, 'activate'])->middleware(['auth', 'verified'])->name('utilizador.activate');
Route::post('/utilizador/deactivate', [UserController::class, 'deactivate'])->middleware(['auth', 'verified'])->name('utilizador.deactivate');
// Users

// Provincias
Route::get('/provincia', [ProvinceController::class, 'index'])->middleware(['auth', 'verified'])->name('provincia.index');
Route::get('/provincia/create', [ProvinceController::class,'create'])->middleware(['auth', 'verified'])->name('provincia.create');
Route::post('/provincia/create', [ProvinceController::class, 'store'])->middleware(['auth', 'verified'])->name('provincia.create');
Route::get('/provincia/{valor}/edit', [ProvinceController::class, 'edit'])->middleware(['auth', 'verified'])->name('provincia.edit');
Route::put('/provincia/{valor}/edit', [ProvinceController::class, 'update'])->middleware(['auth', 'verified'])->name('provincia.edit');
Route::delete('/provincia/destroy', [ProvinceController::class, 'destroy'])->middleware(['auth', 'verified'])->name('provincia.destroy');
// Provincias

// municipios
Route::get('/municipio', [MunicipioController::class, 'index'])->middleware(['auth', 'verified'])->name('municipio.index');
Route::get('/municipio/create', [MunicipioController::class,'create'])->middleware(['auth', 'verified'])->name('municipio.create');
Route::post('/municipio/create', [MunicipioController::class, 'store'])->middleware(['auth', 'verified'])->name('municipio.create');
Route::get('/municipio/{valor}/edit', [MunicipioController::class, 'edit'])->middleware(['auth', 'verified'])->name('municipio.edit');
Route::put('/municipio/{valor}/edit', [MunicipioController::class, 'update'])->middleware(['auth', 'verified'])->name('municipio.edit');
Route::delete('/municipio/destroy', [MunicipioController::class, 'destroy'])->middleware(['auth', 'verified'])->name('municipio.destroy');
// municipios

// parceiros
Route::get('/parceiro', [ParceiroController::class, 'index'])->middleware(['auth', 'verified'])->name('parceiro.index');
Route::get('/parceiro/{valor}/show', [ParceiroController::class,'show'])->middleware(['auth', 'verified'])->name('parceiro.show');
Route::get('/parceiro/create', [ParceiroController::class,'create'])->middleware(['auth', 'verified'])->name('parceiro.create');
Route::post('/parceiro/create', [ParceiroController::class,'store'])->middleware(['auth', 'verified'])->name('parceiro.create');
Route::get('/parceiro/{valor}/edit', [ParceiroController::class, 'edit'])->middleware(['auth', 'verified'])->name('parceiro.edit');
Route::put('/parceiro/{valor}/edit', [ParceiroController::class, 'update'])->middleware(['auth', 'verified'])->name('parceiro.edit');
Route::delete('/parceiro/destroy', [ParceiroController::class, 'destroy'])->middleware(['auth', 'verified'])->name('parceiro.destroy');
// parceiros 

// escolas
Route::get('/escola', [EscolaController::class, 'index'])->middleware(['auth', 'verified'])->name('escola.index');
Route::get('/escola/{valor}/show', [EscolaController::class,'show'])->middleware(['auth', 'verified'])->name('escola.show');
Route::get('/escola/create', [EscolaController::class,'create'])->middleware(['auth', 'verified'])->name('escola.create');
Route::post('/escola/create', [EscolaController::class,'store'])->middleware(['auth', 'verified'])->name('escola.create');
Route::get('/escola/{valor}/edit', [EscolaController::class, 'edit'])->middleware(['auth', 'verified'])->name('escola.edit');
Route::put('/escola/{valor}/edit', [EscolaController::class, 'update'])->middleware(['auth', 'verified'])->name('escola.edit');
Route::delete('/escola/destroy', [EscolaController::class, 'destroy'])->middleware(['auth', 'verified'])->name('escola.destroy');
// escolas 

// niveis
Route::get('/nivel', [NiveiController::class, 'index'])->middleware(['auth', 'verified'])->name('nivel.index');
Route::post('/nivel/activate', [NiveiController::class, 'activate_nivel'])->middleware(['auth', 'verified'])->name('nivel.activate');
Route::post('/nivel/deactivate', [NiveiController::class, 'deactivate_nivel'])->middleware(['auth', 'verified'])->name('nivel.deactivate');

Route::post('/subnivel/activate', [SubniveiController::class, 'activate_subnivel'])->middleware(['auth', 'verified'])->name('subnivel.activate');
Route::post('/subnivel/deactivate', [SubniveiController::class, 'deactivate_subnivel'])->middleware(['auth', 'verified'])->name('subnivel.deactivate');


/*
Route::get('/nivei/{valor}/show', [NiveiController::class,'show'])->middleware(['auth', 'verified'])->name('nivei.show');
Route::get('/nivei/create', [NiveiController::class,'create'])->middleware(['auth', 'verified'])->name('nivei.create');
Route::post('/nivei/create', [NiveiController::class,'store'])->middleware(['auth', 'verified'])->name('nivei.create');
Route::get('/nivei/{valor}/edit', [NiveiController::class, 'edit'])->middleware(['auth', 'verified'])->name('nivei.edit');
Route::put('/nivei/{valor}/edit', [NiveiController::class, 'update'])->middleware(['auth', 'verified'])->name('nivei.edit');
Route::delete('/nivei/destroy', [NiveiController::class, 'destroy'])->middleware(['auth', 'verified'])->name('nivei.destroy');
*/
// niveis 


//registo/create
Route::get('/registo', [RegistoController::class, 'index'])->middleware(['auth', 'verified'])->name('registo.index');
Route::get('/registo/create', [RegistoController::class, 'create'])->middleware(['auth', 'verified'])->name('registo.create');
Route::post('/registo/create', [RegistoController::class, 'store'])->middleware(['auth', 'verified'])->name('registo.create');
Route::put('/registo/{valor}/edit', [RegistoController::class, 'update'])->middleware(['auth', 'verified'])->name('registo.edit');
Route::get('/registo/{valor}/edit', [RegistoController::class, 'edit'])->middleware(['auth', 'verified'])->name('registo.edit');
Route::delete('/registo/destroy', [RegistoController::class, 'destroy'])->middleware(['auth', 'verified'])->name('registo.destroy');
Route::post('/registo/visto', [RegistoController::class, 'visto'])->middleware(['auth', 'verified'])->name('registo.visto');
Route::get('/registo/{valor}/show', [RegistoController::class, 'show'])->middleware(['auth', 'verified'])->name('registo.show');


// Alfabetizadores e turmas

Route::get('/turma', [AlfabetizadoresturmasController::class, 'index'])->middleware(['auth', 'verified'])->name('turma.index');
Route::get('/turma/create', [AlfabetizadoresturmasController::class, 'create'])->middleware(['auth', 'verified'])->name('turma.create');
Route::post('/turma/create', [AlfabetizadoresturmasController::class, 'store'])->middleware(['auth', 'verified'])->name('turma.create');
Route::delete('/turma/destroy', [AlfabetizadoresturmasController::class, 'destroy'])->middleware(['auth', 'verified'])->name('turma.destroy');
Route::put('/turma/{valor}/edit', [AlfabetizadoresturmasController::class, 'update'])->middleware(['auth', 'verified'])->name('turma.edit');
Route::get('/turma/{valor}/edit', [AlfabetizadoresturmasController::class, 'edit'])->middleware(['auth', 'verified'])->name('turma.edit');
Route::post('/turma/{valor}/edit', [AlfabetizadoresturmasController::class, 'change'])->middleware(['auth', 'verified'])->name('turma.edit');


//Alfabetizadores e turmas


// Rota para buscar os aproveitamentos com filtros
// Route::get('/filtrar-aproveitamentos', [DashboardController::class, 'getAproveitamentos']);