<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Entrega-Já</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="<?php echo e(asset('assets/assets/img/favicon.png')); ?>" rel="icon">
  <link href="<?php echo e(asset('assets/assets/img/apple-touch-icon.png')); ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="<?php echo e(asset('assets/assets/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('assets/assets/vendor/bootstrap-icons/bootstrap-icons.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('assets/assets/vendor/boxicons/css/boxicons.min.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('assets/assets/vendor/quill/quill.snow.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('assets/assets/vendor/quill/quill.bubble.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('assets/assets/vendor/remixicon/remixicon.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('assets/assets/vendor/simple-datatables/style.css')); ?>" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="<?php echo e(asset('assets/assets/css/style.css')); ?>" rel="stylesheet">

</head>

<body>  
  
  <!-- ======= Header ======= -->
  <header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="<?php echo e(route('dashboard')); ?>"class="logo d-flex align-items-center">
        <img src="<?php echo e(asset('assets/assets/img/logo.png')); ?>" alt="">
        <span class="d-none d-lg-block">Entrega-Já</span>
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

    <div class="search-bar">
      <form class="search-form d-flex align-items-center" method="POST" action="#">
        <input type="text" name="query" placeholder="Search" title="Enter search keyword">
        <button type="submit" title="Search"><i class="bi bi-search"></i></button>
      </form>
    </div><!-- End Search Bar -->

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">
        <li class="nav-item dropdown pe-3">

          <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
            <img src="<?php echo e(asset('assets/assets/img/profile-img.jpg')); ?>" alt="Profile" class="rounded-circle">
            <span class="d-none d-md-block dropdown-toggle ps-2"><?php echo e(Auth::user()->name); ?></span>
          </a><!-- End Profile Iamge Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header">
              <h6><?php echo e(Auth::user()->name); ?></h6>
              <span><?php echo e(Auth::user()->email); ?></span>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('profile.edit')); ?>">
                <i class="bi bi-person"></i>
                <span>Perfil</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="#">
                <i class="bi bi-question-circle"></i>
                <span>Ajuda?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
                <!-- Authentication -->
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>

                    <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault();
                                        this.closest('form').submit();">
                        
                        <i class="bi bi-box-arrow-right"></i>
                        <span><?php echo e(__('Sair')); ?></span>
                    </a>
                </form>
            </li>

          </ul><!-- End Profile Dropdown Items -->
        </li><!-- End Profile Nav -->

      </ul>
    </nav><!-- End Icons Navigation -->

  </header><!-- End Header -->

  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar" >

    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link " href="<?php echo e(route('dashboard')); ?>">
          <i class="bi bi-grid"></i>
          <span>Dados Analíticos</span>
        </a>
      </li>
      <!-- End Dashboard Nav -->

    <!-- niveis Nav -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#niveis-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-award"></i><span>Nível de Ensino</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="niveis-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
                <a href="<?php echo e(route('nivel.index')); ?>">
                    <i class="bi bi-circle"></i><span>Níveis</span>
                </a>
          </li>
          <li>
                <a href="#">
                    <i class="bi bi-circle"></i><span>Novo</span>
                </a>
          </li>
      </ul>
    </li>
    <!-- End niveis Nav -->

    <!-- localidades Nav -->
      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#localidades-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-map"></i><span>Localidades</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="localidades-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
            <li>
                  <a href="<?php echo e(route('provincia.index')); ?>">
                      <i class="bi bi-circle"></i><span>Províncias</span>
                  </a>
            </li>
            <?php if(Auth::user()->role_id==1 or Auth::user()->role_id==2): ?>
                <li>
                    <a href="<?php echo e(route('provincia.create')); ?> ">
                        <i class="bi bi-circle"></i><span>Nova Província</span>
                    </a>
                </li>
            <?php endif; ?>
            <li>
                <a href="<?php echo e(route('municipio.index')); ?>">
                    <i class="bi bi-circle"></i><span>Municípios</span>
                </a>
            </li>
            <li>
                  <a href="<?php echo e(route('municipio.create')); ?> ">
                      <i class="bi bi-circle"></i><span>Novo Município</span>
                  </a>
            </li>
        </ul>
      </li>
    <!-- End localidades Nav -->

    


    <!-- parceiros Nav -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#parceiros-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-diagram-3"></i><span>Parceirias</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="parceiros-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
                <a href="<?php echo e(route('parceiro.index')); ?>">
                    <i class="bi bi-circle"></i><span>Parceiros</span>
                </a>
          </li>
          <li>
                <a href="<?php echo e(route('parceiro.create')); ?>">
                    <i class="bi bi-circle"></i><span>Novo Parceiro</span>
                </a>
          </li>

          <li>
            <a href="#">
                <i class="bi bi-circle"></i><span>Porjectos</span>
            </a>
          </li>
          <li>
                <a href="#">
                    <i class="bi bi-circle"></i><span>Novo Porjecto</span>
                </a>
          </li>
      </ul>
    </li>
    <!-- End parceiros Nav -->


    <!-- escolas Nav -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#escolas-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-bank"></i><span>Escolas</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="escolas-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
                <a href="<?php echo e(route('escola.index')); ?>">
                    <i class="bi bi-circle"></i><span>Lista</span>
                </a>
          </li>
          <li>
                <a href="<?php echo e(route('escola.create')); ?> ">
                    <i class="bi bi-circle"></i><span>Novo</span>
                </a>
          </li>
      </ul>
    </li>
    <!-- End escolas Nav -->

    <!-- Components Nav -->
      <li class="nav-item">
          <a class="nav-link collapsed" data-bs-target="#components-nav" data-bs-toggle="collapse" href="#">
            <i class="bi bi-folder"></i><span>Registos</span><i class="bi bi-chevron-down ms-auto"></i>
          </a>
          <ul id="components-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
                  <li>
                      <a href="<?php echo e(route('registo.index')); ?>">
                      <i class="bi bi-circle"></i><span>Registos</span>
                      </a>
                  </li>
                  <?php if(Auth::user()->role_id==1 or Auth::user()->role_id==2): ?>
                      <li>
                          <a href="<?php echo e(route('registo.create')); ?> ">
                          <i class="bi bi-circle"></i><span>Novo</span>
                          </a>
                      </li>
                      <li>
                          <a href="#">
                              <i class="bi bi-circle"></i><span>Categorias</span>
                          </a>
                      </li>
                      <li>
                          <a href="#">
                              <i class="bi bi-circle"></i><span>Departamentos</span>
                          </a>
                      </li>
                  <?php endif; ?>
          </ul>
      </li>
    <!-- End Components Nav -->
    <li class="nav-heading">Periodos Lectivos</li>
    <!-- anos nav -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#ano-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-calendar3"></i><span>Anos Lectivo</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="ano-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
              <li>
                  <a href="">
                    <i class="bi bi-circle"></i><span>Anos & Obectivos</span>
                  </a>
              </li>
              <li>
                  <a href="">
                      <i class="bi bi-circle"></i><span>Novo</span>
                  </a>
              </li>
              
      </ul>
    </li>
    <!-- End anos nav -->
    
    <!-- turmas nav -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#turma-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-book"></i><span>Turmas</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="turma-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
              <li>
                  <a href="<?php echo e(route('turma.index')); ?>" title="Dados Iniciais das turmas, durante os arranque da mesma.">
                    <i class="bi bi-circle"></i><span>Dados de Cadastro</span>
                  </a>
              </li>
              <li>
                  <a href="<?php echo e(route('turma.create')); ?> ">
                      <i class="bi bi-circle"></i><span>Novo Cadastro</span>
                  </a>
              </li>
              <li>
                <a href="<?php echo e(route('turma.index')); ?>" title="Dados finais das turmas, Dados geralmente extraídos da avaliação final das turmas.">
                  <i class="bi bi-circle"></i><span>Dados Finais (Pautas Finais)</span>
                </a>
              </li>
              <li>
                <a href="<?php echo e(route('turma.index')); ?>" title="Submeter o Aproveitamento (Dados Finais dos Alunos da turma).">
                  <i class="bi bi-circle"></i><span>Submeter uma Pauta</span>
                </a>
              </li>
              
      </ul>
    </li>
    <!-- End turmas nav -->
    

    <li class="nav-heading">Configurações</li>

    <!-- contas nav -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#conta-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-people"></i><span>Contas</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="conta-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
              <li>
                  <a href="<?php echo e(route('utilizador.index')); ?>">
                    <i class="bi bi-circle"></i><span>Utilizadores</span>
                  </a>
              </li>
              <li>
                  <a href="<?php echo e(route('utilizador.create')); ?> ">
                      <i class="bi bi-circle"></i><span>Novo</span>
                  </a>
              </li>
              
      </ul>
    </li>
    <!-- End contas nav -->
    
    

    

    <li class="nav-item">
      <a class="nav-link collapsed" href="https://wa.me/942719233" target="_blank">
        <i class="bi bi-whatsapp"></i>
        <span>Suporte</span>
      </a>
    </li><!-- End Contact Page Nav -->

    <li class="nav-item">
      <!-- Authentication -->
      <form method="POST" action="<?php echo e(route('logout')); ?>">
        <?php echo csrf_field(); ?>
        <a class="nav-link collapsed" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault();
                            this.closest('form').submit();">
            
            <i class="bi bi-box-arrow-right"></i>
            <span><?php echo e(__('Sair')); ?></span>
        </a>
      </form>
    </li><!-- End Login Page Nav -->
    </ul>

  </aside>
  <!-- End Sidebar-->
  
  <?php echo $__env->yieldContent('content'); ?>

  <!-- ======= Footer ======= -->
  <footer id="footer" class="footer">
      <div class="copyright">
        &copy; Copyright <strong><span>VanSoft</span></strong>. Todos os direitos reservados.
      </div>
      <div class="credits">
        <!-- All the links in the footer should remain intact. -->
        <!-- You can delete the links only if you purchased the pro version. -->
        <!-- Licensing information: https://bootstrapmade.com/license/ -->
        <!-- Purchase the pro version with working PHP/AJAX contact form: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/ -->
      Desenvolvido por <a href="https://www.vansoft.ao/" target="_blank">VanSoft</a>
      </div>
  </footer>
  <!-- End Footer -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="<?php echo e(asset('assets/assets/vendor/apexcharts/apexcharts.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/chart.js/chart.umd.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/echarts/echarts.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/quill/quill.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/simple-datatables/simple-datatables.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/tinymce/tinymce.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/assets/vendor/php-email-form/validate.js')); ?>"></script>

  <!-- Template Main JS File -->
  <script src="<?php echo e(asset('assets/assets/js/main.js')); ?>"></script>

</body>

</html><?php /**PATH C:\xampp\htdocs\projectos\controlav3\resources\views////layouts/navigation.blade.php ENDPATH**/ ?>