<?php $__env->startSection('content'); ?>
   
<main id="main" class="main">

     <!-- Page Title -->
     <div class="pagetitle">
        <h1>Dashboard</h1>
        <nav>
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item active">Dados Analíticos</li>
          </ol>
        </nav>
      </div>
      <!-- End Page Title -->
        <section class="section">
            <div class="row">

                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Aproveitamento</h5>
                                <style>
                                    form { display: flex; flex-wrap: wrap; gap: 10px; }
                                    label { font-weight: bold; }
                                    select, button { padding: 8px; }
                                    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                                    th { background-color: #f4f4f4; }
                                </style>

                                    <h2>Filtrar Aproveitamentos</h2>

                                <form method="GET" action="<?php echo e(url('dashboard')); ?>">
                                    <?php echo csrf_field(); ?>

                                    <label for="ano_id">Ano Letivo:</label>
                                    <select id="ano_id" name="ano_id">
                                        <option value="">Todos</option>
                                        <?php $__currentLoopData = $anos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($ano->id); ?>" <?php echo e(request('ano_id') == $ano->id ? 'selected' : ''); ?>>
                                                <?php echo e($ano->anolectivo); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <label for="provincia_id">Província:</label>
                                    <select id="provincia_id" name="provincia_id">
                                        <option value="">Todas</option>
                                        <?php $__currentLoopData = $provincias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provincia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($provincia->id); ?>" <?php echo e(request('provincia_id') == $provincia->id ? 'selected' : ''); ?>>
                                                <?php echo e($provincia->nome); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <label for="municipio_id">Município:</label>
                                    <select id="municipio_id" name="municipio_id">
                                        <option value="">Todos</option>
                                        <?php $__currentLoopData = $municipios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $municipio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($municipio->id); ?>" <?php echo e(request('municipio_id') == $municipio->id ? 'selected' : ''); ?>>
                                                <?php echo e($municipio->nome); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <label for="turma_id">Turma:</label>
                                    <select id="turma_id" name="turma_id">
                                        <option value="">Todas</option>
                                        <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($turma->id); ?>" <?php echo e(request('turma_id') == $turma->id ? 'selected' : ''); ?>>
                                                <?php echo e($turma->nome_do_responsavel); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <button type="submit">Filtrar</button>
                                </form>

                    <h3>Resultados:</h3>
                    <table>
                        <thead>
                            <tr>
                                <th>Município</th>
                                <th>Ano Letivo</th>
                                <th>Matriculados (MF)</th>
                                <th>Matriculados (F)</th>
                                <th>Aprovados (MF)</th>
                                <th>Aprovados (F)</th>
                                <th>Reprovados (MF)</th>
                                <th>Reprovados (F)</th>
                                <th>Desistentes (MF)</th>
                                <th>Desistentes (F)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $resultados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row->municipio); ?></td>
                                    <td><?php echo e($row->anolectivo); ?></td>
                                    <td><?php echo e($row->total_matriculados_mf); ?></td>
                                    <td><?php echo e($row->total_matriculados_f); ?></td>
                                    <td><?php echo e($row->total_aprovados_mf); ?></td>
                                    <td><?php echo e($row->total_aprovados_f); ?></td>
                                    <td><?php echo e($row->total_reprovados_mf); ?></td>
                                    <td><?php echo e($row->total_reprovados_f); ?></td>
                                    <td><?php echo e($row->total_desistentes_mf); ?></td>
                                    <td><?php echo e($row->total_desistentes_f); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                


                           
                        </div>
                    </div>     
                </div>
                
                <div class="col-lg-8">
                  <div class="card">
                    <div class="card-body">
                      <h5 class="card-title">Registos por Categoria</h5>
                        <select id="filtroCategoria" class="form-select">
                            <option value="todas">Todas</option>
                            <?php $__currentLoopData = $RegistoPorCategoria; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->categoria); ?>"><?php echo e($item->categoria); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      <!-- Bar Chart -->
                      <div id="barChart_registos_por_categoria" style="min-height: 400px;" class="echart"></div>
        
                      <script>
                        document.addEventListener("DOMContentLoaded", () => {
                            let dados = <?php echo json_encode($RegistoPorCategoria, 15, 512) ?>;
                            
                            let categorias = dados.map(item => item.categoria);
                            let valores = dados.map(item => item.qnt);
                        
                            let chart = echarts.init(document.querySelector("#barChart_registos_por_categoria"));
                        
                            function atualizarGrafico(filtro) {
                                let categoriasFiltradas = [];
                                let valoresFiltrados = [];
                        
                                if (filtro === "todas") {
                                    categoriasFiltradas = categorias;
                                    valoresFiltrados = valores;
                                } else {
                                    dados.forEach(item => {
                                        if (item.categoria === filtro) {
                                            categoriasFiltradas.push(item.categoria);
                                            valoresFiltrados.push(item.qnt);
                                        }
                                    });
                                }
                        
                                chart.setOption({
                                    xAxis: {
                                        type: 'category',
                                        data: categoriasFiltradas,
                                        axisLabel: { rotate: 10,fontSize: 7 }
                                    },
                                    yAxis: { type: 'value' },
                                    series: [{
                                        data: valoresFiltrados,
                                        type: 'bar'
                                    }]
                                });
                            }
                        
                            atualizarGrafico("todas");
                        
                            document.getElementById("filtroCategoria").addEventListener("change", function() {
                                atualizarGrafico(this.value);
                            });
                        });
                      </script>
                      <!-- End Bar Chart -->
        
                    </div>
                  </div>
                </div>

                <div class="col-lg-4">
                    <div class="card">
                      <div class="card-body">
                        <h5 class="card-title">Registos por Departamento</h5>
                        <select id="filtroDepartamento" class="form-select">
                            <option value="todas">Todos</option>
                            <?php $__currentLoopData = $RegistoPorDepartamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->cod_dpto); ?>"><?php echo e($item->cod_dpto); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <!-- Bar Chart -->
                        <div id="barChart_registos_por_departamento" style="min-height: 400px;" class="echart"></div>
          
                        <script>
                            document.addEventListener("DOMContentLoaded", () => {
                                let dados = <?php echo json_encode($RegistoPorDepartamento, 15, 512) ?>;
                                
                                let departamentos = dados.map(item => item.cod_dpto);
                                let valores = dados.map(item => item.qnt);
                            
                                let chart = echarts.init(document.querySelector("#barChart_registos_por_departamento"));
                            
                                function atualizarGrafico(filtro) {
                                    let departamentosFiltradas = [];
                                    let valoresFiltrados = [];
                            
                                    if (filtro === "todas") {
                                        departamentosFiltradas = departamentos;
                                        valoresFiltrados = valores;
                                    } else {
                                        dados.forEach(item => {
                                            if (item.cod_dpto === filtro) {
                                                departamentosFiltradas.push(item.cod_dpto);
                                                valoresFiltrados.push(item.qnt);
                                            }
                                        });
                                    }
                            
                                    chart.setOption({
                                        xAxis: {
                                            type: 'category',
                                            data: departamentosFiltradas,
                                            axisLabel: { rotate: 10,fontSize: 7 }
                                        },
                                        yAxis: { type: 'value' },
                                        series: [{
                                            data: valoresFiltrados,
                                            type: 'bar'
                                        }]
                                    });
                                }
                            
                                atualizarGrafico("todas");
                            
                                document.getElementById("filtroDepartamento").addEventListener("change", function() {
                                    atualizarGrafico(this.value);
                                });
                            });
                          </script>
                          <!-- End Bar Chart -->
          
                      </div>
                    </div>
                  </div>
                
              </div>
        </section>

  </main>
  <!-- End #main -->

  

<?php $__env->stopSection(); ?>



<?php echo $__env->make('../layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projectos\controlav3\resources\views/dashboard.blade.php ENDPATH**/ ?>